/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.internal.mylyn;

import java.io.Writer;
import java.util.Map;
import java.util.Objects;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.parser.builder.HtmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.ui.WikiText;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.io.StringBuilderWriter;
import org.eclipse.net4j.util.ui.chat.ChatRenderer;

public final class MylynChatRenderer
extends ChatRenderer {
    private final MarkupLanguage markupLanguage;

    public MylynChatRenderer(String description) {
        String name = Objects.requireNonNullElse(description, "Markdown");
        this.markupLanguage = WikiText.getMarkupLanguage((String)name);
    }

    public void renderHTML(String markup, StringBuilder html, Map<String, Object> properties) {
        StringBuilderWriter out = new StringBuilderWriter(html);
        HtmlDocumentBuilder builder = new HtmlDocumentBuilder((Writer)out, false);
        builder.setEmitAsDocument(false);
        MarkupParser parser = new MarkupParser(this.markupLanguage, (DocumentBuilder)builder);
        parser.parse(markup);
    }

    public static final class Factory
    extends ChatRenderer.Factory {
        public static final String TYPE = "mylyn";

        public Factory() {
            super(TYPE);
        }

        public ChatRenderer create(String description) throws ProductCreationException {
            return new MylynChatRenderer(description);
        }
    }
}

