/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.ws;

import org.eclipse.net4j.internal.ws.WSAcceptor;
import org.eclipse.net4j.util.registry.HashMapRegistry;
import org.eclipse.net4j.util.registry.IRegistry;
import org.eclipse.net4j.ws.IWSAcceptor;
import org.eclipse.net4j.ws.IWSAcceptorManager;

public class WSAcceptorManager
implements IWSAcceptorManager {
    public static final WSAcceptorManager INSTANCE = new WSAcceptorManager();
    private IRegistry<String, IWSAcceptor> acceptorRegistry = new HashMapRegistry();

    @Override
    public IRegistry<String, IWSAcceptor> getAcceptorRegistry() {
        return this.acceptorRegistry;
    }

    @Override
    public WSAcceptor getAcceptor(String name) {
        return (WSAcceptor)this.acceptorRegistry.get((Object)name);
    }

    public boolean registerAcceptor(WSAcceptor acceptor) {
        String name = acceptor.getName();
        if (!this.acceptorRegistry.containsKey((Object)name)) {
            this.acceptorRegistry.put((Object)name, (Object)acceptor);
            return true;
        }
        return false;
    }

    public boolean deregisterAcceptor(WSAcceptor acceptor) {
        return this.acceptorRegistry.remove((Object)acceptor.getName()) != null;
    }
}

