/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lob.CDOLobLoader;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionCrawler;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.common.util.CDOFingerPrinter;
import org.eclipse.net4j.util.StringConverter;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.factory.ProductCreationException;

public class DigestFingerPrinter
implements CDOFingerPrinter {
    public static final String TYPE = "digest";
    public static final String DEFAULT_ALGORITHM = "SHA-512";
    public static final String DEFAULT_ENCODER = "base64";
    private static final String[] NO_PARAMETERS = new String[0];
    private static final String LOCAL_IDS = "localIDs";
    private static final String LOB_VALUES = "lobValues";
    private static final String SEPARATOR = ",";
    private final String param;
    private final String algorithm;
    private final StringConverter encoder;
    private final boolean localIDs;
    private final boolean lobValues;

    public DigestFingerPrinter(String param, IManagedContainer container) {
        String[] tokens = param == null ? NO_PARAMETERS : param.split(SEPARATOR);
        this.algorithm = tokens.length < 1 ? DEFAULT_ALGORITHM : tokens[0];
        this.createMessageDigest();
        String encoderName = tokens.length < 2 ? DEFAULT_ENCODER : tokens[1];
        StringConverter stringConverter = (StringConverter)container.getElementOrNull("org.eclipse.net4j.util.stringConverters", encoderName);
        if (stringConverter != null) {
            this.encoder = stringConverter;
        } else {
            this.encoder = StringConverter.BASE64;
            encoderName = DEFAULT_ENCODER;
        }
        boolean localIDs = false;
        boolean lobValues = false;
        int i = 2;
        while (i < tokens.length) {
            if (LOCAL_IDS.equalsIgnoreCase(tokens[i])) {
                localIDs = true;
            } else if (LOB_VALUES.equalsIgnoreCase(tokens[i])) {
                lobValues = true;
            }
            ++i;
        }
        this.localIDs = localIDs;
        this.lobValues = lobValues;
        this.param = String.valueOf(this.algorithm) + SEPARATOR + encoderName + (localIDs ? ",localIDs" : "") + (lobValues ? ",lobValues" : "");
    }

    @Override
    public final String getType() {
        return TYPE;
    }

    @Override
    public final String getParam() {
        return this.param;
    }

    @Override
    public CDOFingerPrinter.FingerPrint createFingerPrint(CDORevisionProvider revisionProvider, CDOID rootID) {
        CDORevision rootResource = revisionProvider.getRevision(rootID);
        CDOLobLoader lobLoader = null;
        if (this.lobValues && revisionProvider instanceof CDOLobLoader) {
            lobLoader = (CDOLobLoader)((Object)revisionProvider);
        }
        MessageDigest digest = this.createMessageDigest();
        CDORevisionCrawler.MessageDigestHandler handler = new CDORevisionCrawler.MessageDigestHandler(digest, this.localIDs, lobLoader);
        long count = new CDORevisionCrawler().handler(handler).featureStrategy(CDORevisionCrawler.FeatureStrategy.TREE).containmentProxyStrategy(CDORevisionCrawler.ContainmentProxyStrategy.Physical).revisionProvider(revisionProvider).begin().addRevision(rootResource).finish().revisionCount();
        byte[] bytes = digest.digest();
        String value = this.encoder.apply((Object)bytes);
        return new CDOFingerPrinter.FingerPrint(value, count, this.param);
    }

    private MessageDigest createMessageDigest() {
        try {
            return MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    public static class Factory
    extends CDOFingerPrinter.Factory
    implements IManagedContainer.ContainerAware {
        private IManagedContainer container = IPluginContainer.INSTANCE;

        public Factory() {
            this(DigestFingerPrinter.TYPE);
        }

        protected Factory(String type) {
            super(type);
        }

        public void setManagedContainer(IManagedContainer container) {
            this.container = container;
        }

        @Override
        public CDOFingerPrinter create(String param) throws ProductCreationException {
            return new DigestFingerPrinter(param, this.container);
        }
    }
}

