/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.history;

import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.internal.ui.history.Net;
import org.eclipse.emf.cdo.internal.ui.history.Segment;
import org.eclipse.emf.cdo.internal.ui.history.SegmentList;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.swt.graphics.Color;

public final class Branch
extends SegmentList {
    private final CDOBranch cdoBranch;
    private final Color color;
    private Branch baseCommitBranch;
    private long baseCommitTime;
    private long firstCommitTime;
    private long lastCommitTime;

    public Branch(Net net, CDOBranch cdoBranch) {
        super(net);
        this.cdoBranch = cdoBranch;
        this.color = net.getColor(cdoBranch.getID());
        CDOSession session = net.getSession();
        CDOID objectID = net.getObjectID();
        if (objectID != null) {
            CDOBranchPoint lastPoint;
            CDORevisionManager revisionManager = session.getRevisionManager();
            CDORevision lastRevision = revisionManager.getRevision(objectID, lastPoint = cdoBranch.getHead(), -1, 0, true);
            if (lastRevision != null && lastRevision.getBranch() == cdoBranch) {
                CDOBranchVersion firstVersion = cdoBranch.getVersion(1);
                CDORevision firstRevision = revisionManager.getRevisionByVersion(objectID, firstVersion, -1, true);
                this.firstCommitTime = firstRevision.getTimeStamp();
                this.lastCommitTime = lastRevision.getTimeStamp();
            }
        } else {
            CDOCommitInfoManager commitInfoManager = session.getCommitInfoManager();
            CDOCommitInfo firstCommit = commitInfoManager.getFirstOfBranch(cdoBranch);
            if (firstCommit != null) {
                this.firstCommitTime = firstCommit.getTimeStamp();
            }
            this.lastCommitTime = commitInfoManager.getLastCommitOfBranch(cdoBranch, true);
        }
    }

    public CDOBranch getCDOBranch() {
        return this.cdoBranch;
    }

    public Color getColor() {
        return this.color;
    }

    @Deprecated
    public Branch getBaseBranch() {
        CDOBranchPoint cdoBase = this.cdoBranch.getBase();
        CDOBranch cdoBaseBranch = cdoBase.getBranch();
        if (cdoBaseBranch == null) {
            return null;
        }
        Net net = this.getNet();
        return net.getBranch(cdoBaseBranch);
    }

    @Deprecated
    public long getBaseTime() {
        return this.cdoBranch.getBase().getTimeStamp();
    }

    public Branch getBaseCommitBranch() {
        this.determineBaseCommitIfNeeded();
        return this.baseCommitBranch;
    }

    public long getBaseCommitTime() {
        this.determineBaseCommitIfNeeded();
        return this.baseCommitTime;
    }

    public long getFirstCommitTime() {
        return this.firstCommitTime;
    }

    public long getLastCommitTime() {
        return this.lastCommitTime;
    }

    public Segment getSegmentFrom(Segment[] segments) {
        int i = 0;
        while (i < segments.length) {
            Segment segment = segments[i];
            if (segment != null && segment.getBranch() == this) {
                return segment;
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        return "Branch[" + this.cdoBranch.getPathName() + "]";
    }

    void adjustCommitTimes(long time) {
        if (this.firstCommitTime == 0L) {
            this.firstCommitTime = time;
            this.lastCommitTime = time;
        } else {
            if (time < this.firstCommitTime) {
                throw new RuntimeException("Must not happen because the constructor initializes firstCommitTime");
            }
            if (time > this.lastCommitTime) {
                this.lastCommitTime = time;
            }
        }
    }

    private void determineBaseCommitIfNeeded() {
        if (this.baseCommitTime != 0L || this.cdoBranch.isMainBranch()) {
            return;
        }
        CDOCommitInfoManager commitInfoManager = this.getNet().getSession().getCommitInfoManager();
        CDOCommitInfo commitInfo = commitInfoManager.getBaseOfBranch(this.cdoBranch);
        this.baseCommitBranch = this.getNet().getBranch(commitInfo.getBranch());
        this.baseCommitTime = commitInfo.getTimeStamp();
    }

    @Override
    protected Segment getNextSegment(Segment segment) {
        return segment.getNextInBranch();
    }

    @Override
    protected void setNextSegment(Segment segment, Segment nextSegment) {
        segment.setNextInBranch(nextSegment);
    }

    @Override
    protected Segment getPreviousSegment(Segment segment) {
        return segment.getPreviousInBranch();
    }

    @Override
    protected void setPreviousSegment(Segment segment, Segment previousSegment) {
        segment.setPreviousInBranch(previousSegment);
    }
}

