/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.tests.db;

import java.io.File;
import java.sql.Connection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.eclipse.emf.cdo.tests.db.DBConfig;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.derby.EmbeddedDerbyAdapter;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.io.TMPUtil;

public class DerbyConfig
extends DBConfig {
    public static final String DB_ADAPTER_NAME = "Derby";
    private static final long serialVersionUID = 1L;
    private static HashMap<String, File> dbFolders = new HashMap();
    private static HashMap<File, EmbeddedDataSource> dataSources = new HashMap();

    public DerbyConfig() {
        super(DB_ADAPTER_NAME);
    }

    @Override
    protected String getDBAdapterName() {
        return DB_ADAPTER_NAME;
    }

    public Collection<File> getDBFolders() {
        return dbFolders.values();
    }

    @Override
    protected IDBAdapter createDBAdapter() {
        return new EmbeddedDerbyAdapter();
    }

    @Override
    protected DataSource createDataSource(String repoName) {
        boolean needsNewFolder;
        File reusableFolder = dbFolders.get(repoName);
        boolean bl = needsNewFolder = reusableFolder == null;
        if (needsNewFolder) {
            reusableFolder = this.createDBFolder(repoName);
            IOUtil.delete((File)reusableFolder);
            dbFolders.put(repoName, reusableFolder);
        }
        EmbeddedDataSource dataSource = new EmbeddedDataSource();
        dataSource.setDatabaseName(reusableFolder.getAbsolutePath());
        dataSource.setCreateDatabase("create");
        dataSources.put(reusableFolder, dataSource);
        if (!needsNewFolder) {
            this.tearDownClean(reusableFolder);
        }
        return dataSource;
    }

    @Override
    protected Map<String, String> createStoreProperties(String repoName) {
        Map<String, String> props = super.createStoreProperties(repoName);
        props.put("schemaName", "APP");
        return props;
    }

    protected void deactivateRepositories() {
        for (File folder : this.getDBFolders()) {
            this.tearDownClean(folder);
        }
        super.deactivateRepositories();
    }

    protected void tearDownClean(File folder) {
        folder.deleteOnExit();
        Connection connection = null;
        EmbeddedDataSource dataSource = dataSources.get(folder);
        try {
            try {
                connection = dataSource.getConnection();
                DBUtil.dropAllTables((Connection)connection, (String)dataSource.getDatabaseName());
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }
        finally {
            DBUtil.close((Connection)connection);
        }
    }

    protected File createDBFolder(String repo) {
        return TMPUtil.createTempFolder((String)("derby_" + repo + "_"), (String)"_test");
    }
}

