/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLRef;
import org.apache.derby.impl.sql.execute.MatchingClauseConstantAction;
import org.apache.derby.impl.sql.execute.MergeConstantAction;
import org.apache.derby.impl.sql.execute.NoRowsResultSetImpl;
import org.apache.derby.impl.sql.execute.RowUtil;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;
import org.apache.derby.shared.common.error.StandardException;

class MergeResultSet
extends NoRowsResultSetImpl {
    private NoPutResultSet _drivingLeftJoin;
    private MergeConstantAction _constants;
    private ExecRow _row;
    private long _rowCount;
    private TemporaryRowHolderImpl[] _thenRows;
    private BackingStoreHashtable _subjectRowIDs;
    private int _numOpens;

    MergeResultSet(NoPutResultSet drivingLeftJoin, Activation activation) throws StandardException {
        super(activation);
        this._drivingLeftJoin = drivingLeftJoin;
        this._constants = (MergeConstantAction)activation.getConstantAction();
        this._thenRows = new TemporaryRowHolderImpl[this._constants.matchingClauseCount()];
    }

    @Override
    public final long modifiedRowCount() {
        return this._rowCount + RowUtil.getRowCountBase();
    }

    @Override
    public void open() throws StandardException {
        this.setup();
        if (this._numOpens++ == 0) {
            this._drivingLeftJoin.openCore();
        } else {
            this._drivingLeftJoin.reopenCore();
        }
        boolean rowsFound = this.collectAffectedRows();
        if (!rowsFound) {
            this.activation.addWarning(StandardException.newWarning("02000", new Object[0]));
        }
        int clauseCount = this._constants.matchingClauseCount();
        for (int i = 0; i < clauseCount; ++i) {
            this._constants.getMatchingClause(i).executeConstantAction(this.activation, this._thenRows[i]);
        }
        this.cleanUp();
        this.endTime = this.getCurrentTimeMillis();
    }

    @Override
    void setup() throws StandardException {
        super.setup();
        int clauseCount = this._constants.matchingClauseCount();
        for (int i = 0; i < clauseCount; ++i) {
            this._constants.getMatchingClause(i).init();
        }
        this._rowCount = 0L;
    }

    @Override
    public void close() throws StandardException {
        this.close(false);
    }

    @Override
    public void cleanUp() throws StandardException {
        int clauseCount = this._constants.matchingClauseCount();
        for (int i = 0; i < clauseCount; ++i) {
            TemporaryRowHolderImpl thenRows = this._thenRows[i];
            if (thenRows != null) {
                thenRows.close();
                this._thenRows[i] = null;
            }
            this._constants.getMatchingClause(i).cleanUp();
        }
        if (this._drivingLeftJoin != null) {
            this._drivingLeftJoin.close();
        }
        if (this._subjectRowIDs != null) {
            this._subjectRowIDs.close();
            this._subjectRowIDs = null;
        }
        this._numOpens = 0;
    }

    @Override
    public void finish() throws StandardException {
        if (this._drivingLeftJoin != null) {
            this._drivingLeftJoin.finish();
        }
        super.finish();
    }

    boolean collectAffectedRows() throws StandardException {
        boolean rowsFound = false;
        while (true) {
            int clauseIdx;
            this._row = this._drivingLeftJoin.getNextRowCore();
            if (this._row == null) break;
            rowsFound = true;
            DataValueDescriptor rlColumn = this._row.getColumn(this._row.nColumns());
            SQLRef baseRowLocation = null;
            boolean matched = false;
            if (rlColumn != null && !rlColumn.isNull()) {
                matched = true;
                baseRowLocation = new SQLRef((RowLocation)rlColumn.getObject());
                this._row.setColumn(this._row.nColumns(), baseRowLocation);
            }
            MatchingClauseConstantAction matchingClause = null;
            int clauseCount = this._constants.matchingClauseCount();
            for (clauseIdx = 0; clauseIdx < clauseCount; ++clauseIdx) {
                boolean considerClause;
                MatchingClauseConstantAction candidate = this._constants.getMatchingClause(clauseIdx);
                boolean isWhenMatchedClause = false;
                switch (candidate.clauseType()) {
                    case 1: 
                    case 2: {
                        isWhenMatchedClause = true;
                    }
                }
                boolean bl = considerClause = matched == isWhenMatchedClause;
                if (!considerClause || !candidate.evaluateRefinementClause(this.activation)) continue;
                matchingClause = candidate;
                break;
            }
            if (matchingClause == null) continue;
            if (baseRowLocation != null) {
                this.addSubjectRow(baseRowLocation);
            }
            for (int i = 0; i < this._row.nColumns(); ++i) {
                DataValueDescriptor dvd = this._row.getColumn(i + 1);
                if (!(dvd instanceof StreamStorable) || !dvd.hasStream()) continue;
                this._row.setColumn(i + 1, dvd.cloneValue(true));
            }
            this._thenRows[clauseIdx] = matchingClause.bufferThenRow(this.activation, this._thenRows[clauseIdx], this._row);
            ++this._rowCount;
        }
        return rowsFound;
    }

    private void addSubjectRow(SQLRef subjectRowID) throws StandardException {
        if (this._subjectRowIDs == null) {
            this.createSubjectRowIDhashtable();
        }
        if (this._subjectRowIDs.get(subjectRowID) != null) {
            throw StandardException.newException("21000.S.1", new Object[0]);
        }
        DataValueDescriptor[] row = new DataValueDescriptor[]{subjectRowID};
        this._subjectRowIDs.putRow(true, row, null);
    }

    private void createSubjectRowIDhashtable() throws StandardException {
        int[] keyCols = new int[]{0};
        this._subjectRowIDs = new BackingStoreHashtable(this.getActivation().getLanguageConnectionContext().getTransactionExecute(), null, keyCols, false, -1L, -1L, -1, -1.0f, false, false);
    }
}

