/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.sql.SQLException;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Diagnosable;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.SQLExceptionFactory;
import org.apache.derby.client.am.SqlCode;
import org.apache.derby.client.am.Sqlca;
import org.apache.derby.shared.common.error.ExceptionUtil;
import org.apache.derby.shared.common.i18n.MessageUtil;

public class SqlException
extends Exception
implements Diagnosable {
    private static final int DEFAULT_ERRCODE = 99999;
    private transient Sqlca sqlca_ = null;
    private transient int messageNumber_;
    private String message_ = null;
    private String cachedMessage_ = null;
    private String batchPositionLabel_;
    private String sqlstate_ = null;
    private int errorcode_ = 99999;
    private String causeString_ = null;
    protected SqlException nextException_;
    public static final String CLIENT_MESSAGE_RESOURCE_NAME = "org.apache.derby.loc.clientmessages";
    private static SQLExceptionFactory exceptionFactory = new SQLExceptionFactory();
    private static MessageUtil msgutil_;
    protected SQLException wrappedException_;

    public static MessageUtil getMessageUtil() {
        if (msgutil_ == null) {
            msgutil_ = new MessageUtil("org.apache.derby.loc.client.clientmessages");
        }
        return msgutil_;
    }

    SqlException(LogWriter logwriter, ClientMessageId msgid, Object[] args, Throwable cause) {
        this(logwriter, cause, SqlException.getMessageUtil().getCompleteMessage(msgid.msgid, args), ExceptionUtil.getSQLStateFromIdentifier(msgid.msgid), ExceptionUtil.getSeverityFromIdentifier(msgid.msgid));
    }

    SqlException(LogWriter logWriter, ClientMessageId msgid, Object[] args, SqlCode sqlcode, Throwable t) {
        this(logWriter, msgid, args, t);
        this.errorcode_ = sqlcode.getCode();
    }

    public SqlException(LogWriter logWriter, ClientMessageId msgid, SqlCode sqlcode, Object ... args) {
        this(logWriter, msgid, args, sqlcode, null);
    }

    public SqlException(LogWriter logWriter, ClientMessageId msgid, Throwable cause, Object ... args) {
        this(logWriter, msgid, args, cause);
    }

    public SqlException(LogWriter logwriter, ClientMessageId msgid, Object ... args) {
        this(logwriter, msgid, args, null);
    }

    public SqlException(LogWriter logWriter, Sqlca sqlca) {
        this(sqlca, 0, true);
        this.errorcode_ = sqlca.getErrorCode();
        if (logWriter != null) {
            logWriter.traceDiagnosable(this);
        }
    }

    private SqlException(Sqlca sqlca, int number, boolean chain) {
        this.sqlca_ = sqlca;
        this.messageNumber_ = number;
        this.sqlstate_ = sqlca.getSqlState(number);
        if ("01004".equals(this.sqlstate_)) {
            this.wrappedException_ = sqlca.getDataTruncation();
        }
        int nextMsg = number + 1;
        if (chain && sqlca.numberOfMessages() > nextMsg) {
            this.setThrowable(new SqlException(sqlca, nextMsg, true));
        }
    }

    private SqlException(LogWriter logWriter, String reason, String sqlState, int errorCode) {
        this(logWriter, (Throwable)null, reason, sqlState, errorCode);
    }

    private SqlException(LogWriter logWriter, Throwable throwable, String reason, String sqlState, int errorCode) {
        this.message_ = reason;
        this.sqlstate_ = sqlState;
        this.errorcode_ = errorCode;
        this.setThrowable(throwable);
        if (logWriter != null) {
            logWriter.traceDiagnosable(this);
        }
    }

    private void setThrowable(Throwable throwable) {
        if (throwable instanceof SqlException) {
            this.setNextException((SqlException)throwable);
        } else if (throwable instanceof SQLException) {
            this.setNextException((SQLException)throwable);
        }
        if (throwable != null) {
            this.initCause(throwable);
        }
    }

    public SqlException(SQLException wrapme) {
        this.wrappedException_ = wrapme;
    }

    public SQLException getSQLException() {
        if (this.wrappedException_ != null) {
            return this.wrappedException_;
        }
        SQLException sqle = exceptionFactory.getSQLException(this.getMessage(), this.getSQLState(), this.getErrorCode(), this.getArgs());
        sqle.initCause(this);
        if (this.nextException_ != null) {
            sqle.setNextException(this.nextException_.getSQLException());
        }
        return sqle;
    }

    void setBatchPositionLabel(int index) {
        this.batchPositionLabel_ = SqlException.getMessageUtil().getTextMessage("J107", new Object[0]) + index + ": ";
    }

    @Override
    public Sqlca getSqlca() {
        return this.sqlca_;
    }

    @Override
    public String toString() {
        return "ERROR " + this.getSQLState() + ": " + this.getMessage();
    }

    private Object[] getArgs() {
        if (this.sqlca_ != null) {
            return this.sqlca_.getArgs(this.messageNumber_);
        }
        return null;
    }

    @Override
    public String getMessage() {
        if (this.wrappedException_ != null) {
            return this.wrappedException_.getMessage();
        }
        if (this.sqlca_ != null) {
            this.cachedMessage_ = this.message_ = this.sqlca_.getJDBCMessage(this.messageNumber_);
        } else if (this.cachedMessage_ != null) {
            this.message_ = this.cachedMessage_;
        }
        if (this.batchPositionLabel_ != null) {
            this.message_ = this.batchPositionLabel_ + this.message_;
        }
        if (this.causeString_ != null) {
            this.message_ = this.message_ + this.causeString_;
        }
        return this.message_;
    }

    public String getSQLState() {
        if (this.wrappedException_ != null) {
            return this.wrappedException_.getSQLState();
        }
        return this.sqlstate_;
    }

    public int getErrorCode() {
        if (this.wrappedException_ != null) {
            return this.wrappedException_.getErrorCode();
        }
        return this.errorcode_;
    }

    public SqlException getNextException() {
        if (this.wrappedException_ != null) {
            return new SqlException(this.wrappedException_.getNextException());
        }
        return this.nextException_;
    }

    public void setNextException(SqlException nextException) {
        if (this.wrappedException_ != null) {
            this.wrappedException_.setNextException(nextException.getSQLException());
        } else {
            this.nextException_ = nextException;
        }
    }

    public void setNextException(SQLException nextException) {
        if (this.wrappedException_ != null) {
            this.wrappedException_.setNextException(nextException);
        } else {
            SqlException theEnd = this;
            while (theEnd.nextException_ != null) {
                theEnd = theEnd.nextException_;
            }
            theEnd.nextException_ = new SqlException(nextException);
        }
    }

    static SqlException javaException(LogWriter logWriter, Throwable e) {
        return new SqlException(logWriter, new ClientMessageId("XJ001.U"), new Object[]{e.getClass().getName(), e.getMessage()}, e);
    }

    SqlException copyAsUnchainedSQLException(LogWriter logWriter) {
        if (this.sqlca_ != null) {
            return new SqlException(this.sqlca_, this.messageNumber_, false);
        }
        return new SqlException(logWriter, this.getMessage(), this.getSQLState(), this.getErrorCode());
    }
}

