/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.net4j.util.concurrent.Worker;
import org.eclipse.net4j.util.lifecycle.LifecycleState;

public abstract class QueueWorker<E>
extends Worker {
    public static final int DEFAULT_POLL_MILLIS = 100;
    private BlockingQueue<E> queue = this.createQueue();
    private long pollMillis;

    public QueueWorker() {
        this.setPollMillis(100L);
    }

    public long getPollMillis() {
        return this.pollMillis;
    }

    public void setPollMillis(long pollMillis) {
        this.pollMillis = pollMillis;
    }

    public void clearQueue() {
        this.queue.clear();
    }

    public boolean addWork(E element) {
        if (this.getLifecycleState() != LifecycleState.DEACTIVATING) {
            return this.queue.offer(element);
        }
        return false;
    }

    @Override
    protected void work(Worker.WorkContext context) throws Exception {
        this.doWork(context);
    }

    private void doWork(Worker.WorkContext context) throws InterruptedException {
        E element = this.pollQueue();
        if (element != null) {
            this.work(context, element);
        } else {
            this.noWork(context);
        }
    }

    private E pollQueue() throws InterruptedException {
        return this.queue.poll(this.pollMillis, TimeUnit.MILLISECONDS);
    }

    protected abstract void work(Worker.WorkContext var1, E var2);

    protected void noWork(Worker.WorkContext context) {
    }

    protected BlockingQueue<E> createQueue() {
        return new LinkedBlockingQueue();
    }

    protected boolean doRemainingWorkBeforeDeactivate() {
        return false;
    }

    @Override
    protected void doDeactivate() throws Exception {
        super.doDeactivate();
        if (this.doRemainingWorkBeforeDeactivate()) {
            Worker.WorkContext context = new Worker.WorkContext(this);
            while (!this.queue.isEmpty()) {
                this.doWork(context);
            }
        } else {
            this.queue.clear();
        }
    }
}

