/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.repositories.wizards;

import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.explorer.ui.repositories.wizards.AbstractRepositoryPage;
import org.eclipse.emf.cdo.explorer.ui.repositories.wizards.NewRepositoryWizard;
import org.eclipse.emf.cdo.explorer.ui.repositories.wizards.RepositoryClonePage;
import org.eclipse.emf.cdo.explorer.ui.repositories.wizards.RepositoryLocalPage;
import org.eclipse.emf.cdo.explorer.ui.repositories.wizards.RepositoryRemotePage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RepositoryTypePage
extends WizardPage {
    private AbstractRepositoryPage nextPage;

    public RepositoryTypePage() {
        super("wizardPage");
        this.setImageDescriptor(OM.getImageDescriptor("icons/wiz/new_repo.gif"));
        this.setTitle("New Repository");
        this.setMessage("Select the type of the new repository.");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout containerGridLayout = new GridLayout();
        container.setLayout((Layout)containerGridLayout);
        this.setControl((Control)container);
        Composite composite = new Composite(container, 0);
        composite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        composite.setLayout((Layout)new GridLayout(1, false));
        NewRepositoryWizard wizard = this.getWizard();
        RepositoryRemotePage remotePage = wizard.getRemotePage();
        this.addChoice(composite, "Connect to an existing remote repository.", "icons/wiz/new_repo_remote.gif", remotePage, true);
        RepositoryClonePage clonePage = wizard.getClonePage();
        this.addChoice(composite, "Clone an existing remote repository.", "icons/wiz/new_repo_clone.gif", clonePage, false);
        RepositoryLocalPage localPage = wizard.getLocalPage();
        this.addChoice(composite, "Create a new local repository.", "icons/wiz/new_repo_local.gif", localPage, true);
        this.nextPage = remotePage;
        this.setPageComplete(true);
    }

    private Button addChoice(Composite composite, String text, String imagePath, final AbstractRepositoryPage nextPage, boolean enabled) {
        this.nextPage = nextPage;
        final SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RepositoryTypePage.this.nextPage = nextPage;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
                RepositoryTypePage.this.getContainer().showPage((IWizardPage)nextPage);
            }
        };
        Button button = new Button(composite, 16);
        button.setText(text);
        button.setEnabled(enabled);
        button.addSelectionListener(listener);
        button.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                listener.widgetDefaultSelected(null);
            }
        });
        Label imageLabel = new Label(composite, 0);
        imageLabel.setImage(OM.getImage(imagePath));
        imageLabel.setEnabled(enabled);
        new Label(composite, 0);
        return button;
    }

    public NewRepositoryWizard getWizard() {
        return (NewRepositoryWizard)super.getWizard();
    }

    public AbstractRepositoryPage getNextPage() {
        return this.nextPage;
    }
}

