/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.impl.store.raw.data.AllocPage;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class AllocExtent
implements Externalizable {
    private long extentOffset;
    private long extentStart;
    private long extentEnd;
    private int extentLength;
    int extentStatus;
    private int preAllocLength;
    private int reserved1;
    private long reserved2;
    private long reserved3;
    private static final int HAS_DEALLOCATED = 1;
    private static final int HAS_FREE = 2;
    private static final int ALL_FREE = 4;
    private static final int HAS_UNFILLED_PAGES = 16;
    private static final int KEEP_UNFILLED_PAGES = 0x10000000;
    private static final int NO_DEALLOC_PAGE_MAP = 0x20000000;
    private static final int RETIRED = 8;
    protected static final int ALLOCATED_PAGE = 0;
    protected static final int DEALLOCATED_PAGE = 1;
    protected static final int FREE_PAGE = 2;
    FormatableBitSet freePages;
    FormatableBitSet unFilledPages;

    protected static int MAX_RANGE(int availspace) {
        int bookkeeping = 56;
        availspace -= bookkeeping;
        if ((availspace /= 3) <= 0) {
            return 0;
        }
        return FormatableBitSet.maxBitsForSpace(availspace);
    }

    protected AllocExtent(long offset, long start, int length, int pagesize, int maxlength) {
        if (length > maxlength) {
            SanityManager.THROWASSERT("length " + length + " > maxlength " + maxlength);
        }
        this.extentOffset = offset;
        this.extentStart = start;
        this.extentEnd = start + (long)maxlength - 1L;
        this.preAllocLength = this.extentLength = length;
        this.extentStatus = length > 0 ? 6 : 0;
        this.extentStatus |= 0x10000000;
        this.extentStatus |= 0x20000000;
        int numbits = (1 + length / 8) * 8;
        if (numbits > maxlength) {
            numbits = maxlength;
        }
        this.freePages = new FormatableBitSet(numbits);
        this.unFilledPages = new FormatableBitSet(numbits);
        for (int i = 0; i < length; ++i) {
            this.freePages.set(i);
        }
    }

    protected AllocExtent(AllocExtent original) {
        this.extentOffset = original.extentOffset;
        this.extentStart = original.extentStart;
        this.extentEnd = original.extentEnd;
        this.extentLength = original.extentLength;
        this.extentStatus = original.extentStatus;
        this.preAllocLength = original.preAllocLength;
        this.freePages = new FormatableBitSet(original.freePages);
        this.unFilledPages = new FormatableBitSet(original.unFilledPages);
    }

    public AllocExtent() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.extentOffset);
        out.writeLong(this.extentStart);
        out.writeLong(this.extentEnd);
        out.writeInt(this.extentLength);
        out.writeInt(this.extentStatus);
        out.writeInt(this.preAllocLength);
        out.writeInt(0);
        out.writeLong(0L);
        out.writeLong(0L);
        this.freePages.writeExternal(out);
        this.unFilledPages.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.extentOffset = in.readLong();
        this.extentStart = in.readLong();
        this.extentEnd = in.readLong();
        this.extentLength = in.readInt();
        this.extentStatus = in.readInt();
        this.preAllocLength = in.readInt();
        this.reserved1 = in.readInt();
        this.reserved2 = in.readLong();
        this.reserved3 = in.readLong();
        this.freePages = new FormatableBitSet();
        this.freePages.readExternal(in);
        if ((this.extentStatus & 0x20000000) == 0) {
            FormatableBitSet deAllocPages = new FormatableBitSet();
            deAllocPages.readExternal(in);
            this.freePages.or(deAllocPages);
            this.extentStatus |= 0x20000000;
        }
        if ((this.extentStatus & 0x10000000) == 0x10000000) {
            this.unFilledPages = new FormatableBitSet();
            this.unFilledPages.readExternal(in);
        } else {
            this.unFilledPages = new FormatableBitSet(this.freePages.getLength());
            this.extentStatus |= 0x10000000;
        }
    }

    protected void allocPage(long pagenum) throws StandardException {
        int numPageAlloced;
        int bitnum;
        if (pagenum > this.getLastPagenum()) {
            if (pagenum > this.extentEnd) {
                SanityManager.THROWASSERT("pagenum " + pagenum + " is out of beyond my range (" + this.extentStart + "," + this.extentEnd + ")");
            }
            if (pagenum != this.getLastPagenum() + 1L) {
                SanityManager.THROWASSERT("skipping pages, lastPageNumber = " + this.getLastPagenum() + " pageNumber = " + pagenum + "\n");
            }
        } else {
            this.checkInRange(pagenum);
            bitnum = (int)(pagenum - this.extentStart);
            if (!this.freePages.isSet(bitnum)) {
                SanityManager.THROWASSERT("trying to re-allocate a page ( " + pagenum + " ) that is already allocated ");
            }
        }
        if ((bitnum = (int)(pagenum - this.extentStart)) >= this.freePages.getLength()) {
            int numbits = (1 + bitnum / 8) * 8;
            if (numbits > (int)(this.extentEnd - this.extentStart + 1L)) {
                numbits = (int)(this.extentEnd - this.extentStart + 1L);
            }
            this.freePages.grow(numbits);
            this.unFilledPages.grow(numbits);
        }
        if ((numPageAlloced = (int)(pagenum - this.extentStart + 1L)) > this.extentLength) {
            this.extentLength = numPageAlloced;
        }
        this.freePages.clear(bitnum);
    }

    protected void deallocPage(long pagenum) throws StandardException {
        int bitnum = (int)(pagenum - this.extentStart);
        if (this.freePages.isSet(bitnum)) {
            SanityManager.THROWASSERT("trying to deallocate a deallocated page " + pagenum);
        }
        this.freePages.set(bitnum);
        this.unFilledPages.clear(bitnum);
        this.setExtentFreePageStatus(true);
    }

    protected int compress(BaseContainerHandle owner, RawTransaction ntt, AllocPage alloc_page) throws StandardException {
        int compress_bitnum = -1;
        int num_pages_compressed = 0;
        int i = this.extentLength - 1;
        while (i >= 0 && this.freePages.isSet(i)) {
            compress_bitnum = i--;
            ++num_pages_compressed;
        }
        int new_highest_page = compress_bitnum - 1;
        if (num_pages_compressed > 0) {
            for (int i2 = new_highest_page + 1; i2 < this.extentLength; ++i2) {
                if (this.freePages.isSet(i2)) continue;
                SanityManager.THROWASSERT("compressPages with nonfree pg to truncate,new_highest_page = " + new_highest_page + "num_pages_truncated = " + num_pages_compressed + ";extentLength = " + this.extentLength + ";extentStart = " + this.extentStart + ";freePages.isSet(" + i2 + ") = " + this.freePages.isSet(i2) + "\nextent:\n" + this.toDebugString());
            }
            SanityManager.ASSERT(new_highest_page + num_pages_compressed + 1 == this.extentLength, "truncate page count did not match: ;new_highest_page = " + new_highest_page + ";num_pages_truncated = " + num_pages_compressed + ";extentLength = " + this.extentLength);
            if (this.extentStart == 1L) {
                SanityManager.ASSERT(new_highest_page >= 0);
                if (num_pages_compressed >= this.extentLength) {
                    SanityManager.THROWASSERT("new_highest_page = " + new_highest_page + "num_pages_compressed = " + num_pages_compressed + "; extentLength = " + this.extentLength + "extent:\n" + this.toDebugString());
                }
            }
            owner.getAllocationActionSet().actionCompressSpaceOperation(ntt, alloc_page, new_highest_page, num_pages_compressed);
            return compress_bitnum;
        }
        return -1;
    }

    protected void compressPages(int new_highest_page, int num_pages_truncated) {
        if (new_highest_page >= 0) {
            for (int i = new_highest_page + 1; i < this.extentLength; ++i) {
                if (this.freePages.isSet(i)) continue;
                SanityManager.THROWASSERT("compressPages with non free page to truncate,new_highest_page = " + new_highest_page + "num_pages_truncated = " + num_pages_truncated + ";extentLength = " + this.extentLength + ";extentStart = " + this.extentStart + ";freePages.isSet(" + i + ") = " + this.freePages.isSet(i) + "\nextent:\n" + this.toDebugString());
            }
        }
        SanityManager.ASSERT(new_highest_page + num_pages_truncated + 1 == this.extentLength, "truncate page count did not match: ;new_highest_page = " + new_highest_page + ";num_pages_truncated = " + num_pages_truncated + ";extentLength = " + this.extentLength);
        if (this.extentStart == 1L) {
            SanityManager.ASSERT(new_highest_page >= 0);
            SanityManager.ASSERT(num_pages_truncated < this.extentLength);
        }
        if (new_highest_page + 1 >= 0) {
            this.freePages.shrink(new_highest_page + 1);
            this.unFilledPages.shrink(new_highest_page + 1);
            this.preAllocLength = this.extentLength = new_highest_page + 1;
        }
    }

    protected void undoCompressPages(int new_highest_page, int num_pages_truncated) {
        if (new_highest_page >= 0) {
            this.freePages.shrink(new_highest_page + 1);
            this.unFilledPages.shrink(new_highest_page + 1);
            this.preAllocLength = this.extentLength = new_highest_page + 1;
        }
    }

    protected long getExtentEnd() {
        return this.extentEnd;
    }

    protected long getFreePageNumber(long pnum) {
        if (this.mayHaveFreePage()) {
            int i;
            int n = i = pnum < this.extentStart ? this.freePages.anySetBit() : this.freePages.anySetBit((int)(pnum - this.extentStart));
            if (i != -1) {
                if (i >= this.extentLength) {
                    SanityManager.THROWASSERT("returned bit = " + i + " extent length = " + this.extentLength);
                }
                return (long)i + this.extentStart;
            }
            if (pnum < this.extentStart) {
                this.setExtentFreePageStatus(false);
            }
        }
        SanityManager.ASSERT(this.extentStart + (long)this.extentLength <= this.extentEnd);
        return this.extentStart + (long)this.extentLength;
    }

    protected long getPageOffset(long pagenum, int pagesize, boolean deallocOK) throws StandardException {
        return pagenum * (long)pagesize;
    }

    protected boolean isRetired() {
        return (this.extentStatus & 8) != 0;
    }

    private boolean mayHaveFreePage() {
        return (this.extentStatus & 2) != 0;
    }

    private void setExtentFreePageStatus(boolean hasFree) {
        this.extentStatus = hasFree ? (this.extentStatus |= 2) : (this.extentStatus &= 0xFFFFFFFD);
    }

    protected boolean canAddFreePage(long lastAllocatedPage) {
        if (this.extentStart + (long)this.extentLength <= this.extentEnd) {
            return true;
        }
        if (!this.mayHaveFreePage()) {
            return false;
        }
        if (lastAllocatedPage < this.extentStart) {
            return this.freePages.anySetBit() != -1;
        }
        return this.freePages.anySetBit((int)(lastAllocatedPage - this.extentStart)) != -1;
    }

    protected int getPageStatus(long pagenum) {
        this.checkInRange(pagenum);
        int status = 0;
        int bitnum = (int)(pagenum - this.extentStart);
        status = this.freePages.isSet(bitnum) ? 2 : 0;
        return status;
    }

    protected long getFirstPagenum() {
        return this.extentStart;
    }

    protected long getLastPagenum() {
        return this.extentStart + (long)this.extentLength - 1L;
    }

    protected long getPagenum(int bit_pos) {
        return this.extentStart + (long)bit_pos;
    }

    protected long getLastPreallocPagenum() {
        if (this.extentLength > this.preAllocLength) {
            this.preAllocLength = this.extentLength;
        }
        return this.extentStart + (long)this.preAllocLength - 1L;
    }

    protected void setLastPreallocPagenum(long preAllocPagenum) {
        SanityManager.ASSERT(preAllocPagenum >= this.getLastPreallocPagenum(), "setLastPreallocPagenum set to small prealloc length than before");
        if (preAllocPagenum > this.extentEnd) {
            preAllocPagenum = this.extentEnd;
        }
        this.preAllocLength = (int)(preAllocPagenum - this.extentStart + 1L);
    }

    protected long getNextValidPageNumber(long prevPageNumber) {
        int status;
        long pageNum;
        long lastpage = this.getLastPagenum();
        for (pageNum = prevPageNumber < this.extentStart ? this.extentStart : prevPageNumber + 1L; pageNum <= lastpage && (status = this.getPageStatus(pageNum)) != 0; ++pageNum) {
        }
        if (pageNum > lastpage) {
            pageNum = -1L;
        }
        return pageNum;
    }

    protected long getLastValidPageNumber() {
        int status;
        long pageNum;
        for (pageNum = this.getLastPagenum(); pageNum >= this.extentStart && (status = this.getPageStatus(pageNum)) != 0; --pageNum) {
        }
        if (pageNum < this.extentStart) {
            pageNum = -1L;
        }
        return pageNum;
    }

    private void checkInRange(long pagenum) {
        if (pagenum < this.extentStart || pagenum >= this.extentStart + (long)this.extentLength) {
            SanityManager.THROWASSERT("pagenum " + pagenum + " out of range");
        }
    }

    protected void updateUnfilledPageInfo(AllocExtent inputExtent) {
        if (inputExtent.unFilledPages.getLength() != this.unFilledPages.getLength()) {
            SanityManager.THROWASSERT("inputExtent's unfilled page length " + inputExtent.unFilledPages.getLength() + " != extent's unfilled page length " + this.unFilledPages.getLength());
        }
        this.unFilledPages = inputExtent.unFilledPages;
        this.extentStatus = this.unFilledPages.anySetBit() >= 0 ? (this.extentStatus |= 0x10) : (this.extentStatus &= 0xFFFFFFEF);
    }

    protected boolean trackUnfilledPage(long pagenumber, boolean unfilled) {
        this.checkInRange(pagenumber);
        int bitnum = (int)(pagenumber - this.extentStart);
        boolean bitSet = this.unFilledPages.isSet(bitnum);
        if (unfilled != bitSet) {
            if (unfilled) {
                this.unFilledPages.set(bitnum);
                this.extentStatus |= 0x10;
            } else {
                this.unFilledPages.clear(bitnum);
            }
            return true;
        }
        return false;
    }

    protected long getUnfilledPageNumber(long pagenum) {
        if ((this.extentStatus & 0x10) == 0) {
            return -1L;
        }
        int i = this.unFilledPages.anySetBit();
        if (i != -1) {
            if ((long)i + this.extentStart != pagenum) {
                return (long)i + this.extentStart;
            }
            if ((i = this.unFilledPages.anySetBit(i)) != -1) {
                return (long)i + this.extentStart;
            }
        }
        return -1L;
    }

    protected int getAllocatedPageCount() {
        int allocatedPageCount = this.extentLength;
        if (!this.mayHaveFreePage()) {
            return allocatedPageCount;
        }
        byte[] free = this.freePages.getByteArray();
        int numBytes = free.length;
        for (int i = 0; i < numBytes; ++i) {
            if (free[i] == 0) continue;
            for (int j = 0; j < 8; ++j) {
                if ((1 << j & free[i]) == 0) continue;
                --allocatedPageCount;
            }
        }
        if (allocatedPageCount < 0) {
            SanityManager.THROWASSERT("number of allocated page < 0, val =" + allocatedPageCount + "\nextent = " + this.toDebugString());
        }
        return allocatedPageCount;
    }

    protected int getUnfilledPageCount() {
        int unfilledPageCount = 0;
        int freePagesSize = this.freePages.size();
        for (int i = 0; i < this.unFilledPages.size(); ++i) {
            if (!this.unFilledPages.isSet(i) || i < freePagesSize && this.freePages.isSet(i)) continue;
            ++unfilledPageCount;
        }
        SanityManager.ASSERT(unfilledPageCount >= 0, "number of unfilled pages < 0");
        return unfilledPageCount;
    }

    protected int getTotalPageCount() {
        return this.extentLength;
    }

    protected String toDebugString() {
        String str = "------------------------------------------------------------------------------\nExtent map of from page " + this.extentStart + " to page " + this.extentEnd + "\n";
        block4: for (long i = this.extentStart; i < this.extentStart + (long)this.extentLength; ++i) {
            str = str + "\tpage " + i + ": ";
            switch (this.getPageStatus(i)) {
                case 2: {
                    str = str + "free page\n";
                    continue block4;
                }
                case 0: {
                    str = str + "valid, in use page\n";
                }
            }
        }
        if (this.getLastPagenum() < this.extentEnd) {
            str = str + "\tFrom " + this.getLastPagenum() + " to " + this.extentEnd + " are un-allocated pages\n";
        }
        str = str + "------------------------------------------------------------------------------\n";
        return str;
    }
}

