/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.trace;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.internal.net4j.buffer.Buffer;
import org.eclipse.net4j.util.ReflectUtil;

public final class ElementCounters {
    public static final ElementCounters INSTANCE = new ElementCounters();
    private final Map<String, AtomicInteger> map = new HashMap<String, AtomicInteger>();

    private ElementCounters() {
    }

    public int nextID(String type) {
        AtomicInteger counter = this.map.get(type);
        if (counter == null) {
            counter = new AtomicInteger();
            this.map.put(type, counter);
        }
        return counter.incrementAndGet();
    }

    public void load(Properties properties) {
        String lastBufferID = (String)properties.remove("Buffer");
        if (lastBufferID != null) {
            AtomicInteger lastID = ElementCounters.getBufferCounter();
            lastID.set(Integer.parseInt(lastBufferID));
        }
        this.map.clear();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String type = (String)entry.getKey();
            int counter = Integer.parseInt((String)entry.getValue());
            this.map.put(type, new AtomicInteger(counter));
        }
    }

    public void save(Properties properties) {
        for (Map.Entry<String, AtomicInteger> entry : this.map.entrySet()) {
            String type = entry.getKey();
            AtomicInteger counter = entry.getValue();
            properties.setProperty(type, Integer.toString(counter.get()));
        }
        AtomicInteger lastID = ElementCounters.getBufferCounter();
        int lastBufferID = lastID.get();
        properties.setProperty("Buffer", Integer.toString(lastBufferID));
    }

    private static AtomicInteger getBufferCounter() {
        return (AtomicInteger)ReflectUtil.getValue((Field)ReflectUtil.getField(Buffer.class, (String)"lastID"), null);
    }
}

