/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.ui.dialogs;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.internal.ui.CDOAdapterFactoryContentProvider;
import org.eclipse.emf.cdo.internal.ui.CDOContentProvider;
import org.eclipse.emf.cdo.internal.ui.RunnableViewerRefresh;
import org.eclipse.emf.cdo.lm.assembly.Assembly;
import org.eclipse.emf.cdo.lm.assembly.AssemblyModule;
import org.eclipse.emf.cdo.lm.internal.client.LMResourceSetConfiguration;
import org.eclipse.emf.cdo.lm.ui.bundle.OM;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.widgets.BaseDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class SelectModuleResourcesDialog
extends BaseDialog<TreeViewer> {
    private final Set<URI> uris = new HashSet<URI>();
    private final boolean multi;
    private final LMResourceSetConfiguration configuration;

    public SelectModuleResourcesDialog(Shell shell, boolean multi, LMResourceSetConfiguration configuration) {
        super(shell, 66800, "Select Module Resources", "Select resources from the current module and its dependencies.", OM.Activator.INSTANCE.getDialogSettings(), OM.Activator.INSTANCE.loadImageDescriptor("icons/NewModule.png"));
        this.multi = multi;
        this.configuration = configuration;
    }

    public Set<URI> getURIs() {
        return this.uris;
    }

    protected void createUI(Composite parent) {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(EMFEditPlugin.getComposedAdapterFactoryDescriptorRegistry());
        adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        TreeViewer viewer = new TreeViewer(parent, this.multi ? 2 : 4);
        viewer.getTree().setLayoutData((Object)UIUtil.createGridData());
        viewer.setContentProvider((IContentProvider)new ModuleResourcesContentProvider(adapterFactory));
        viewer.setLabelProvider((IBaseLabelProvider)new ModuleResourcesLabelProvider((AdapterFactory)adapterFactory));
        viewer.setInput((Object)this.configuration);
        viewer.addDoubleClickListener(e -> this.okPressed());
        viewer.addSelectionChangedListener(e -> this.selectionChanged());
        this.setCurrentViewer((Viewer)viewer);
        UIUtil.asyncExec((Display)parent.getDisplay(), () -> this.selectionChanged());
    }

    protected void selectionChanged() {
        this.uris.clear();
        ITreeSelection selection = ((TreeViewer)this.getCurrentViewer()).getStructuredSelection();
        for (Object object : selection) {
            if (!(object instanceof CDOResource)) continue;
            this.uris.add(((CDOResource)object).getURI());
        }
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(!this.uris.isEmpty());
        }
    }

    private static final class ModuleResourcesContentProvider
    extends CDOContentProvider.ContextFree {
        private final ComposedAdapterFactory adapterFactory;
        private final CDOAdapterFactoryContentProvider delegate;
        private final Map<AssemblyModule, CDOView> views = new LinkedHashMap<AssemblyModule, CDOView>();
        private LMResourceSetConfiguration configuration;

        public ModuleResourcesContentProvider(ComposedAdapterFactory adapterFactory) {
            this.adapterFactory = adapterFactory;
            this.delegate = new CDOAdapterFactoryContentProvider((AdapterFactory)adapterFactory);
        }

        public void inputChanged(Viewer newViewer, Object oldInput, Object newInput) {
            super.inputChanged(newViewer, oldInput, newInput);
            this.delegate.inputChanged(newViewer, oldInput, newInput);
            this.configuration = (LMResourceSetConfiguration)this.getInput();
            this.views.clear();
            if (this.configuration != null) {
                Assembly assembly = this.configuration.getAssembly();
                AssemblyModule rootModule = assembly.getRootModule();
                this.views.put(rootModule, CDOUtil.getViewSet((Notifier)this.configuration.getResourceSet()).getViews()[0]);
                assembly.forEachDependency(module -> {
                    CDOView cDOView = this.views.put((AssemblyModule)module, this.configuration.getView(module));
                });
            }
        }

        public boolean hasChildren(Object object) {
            if (object instanceof CDOResource) {
                return false;
            }
            return super.hasChildren(object);
        }

        public Object[] getChildren(Object object) {
            if (object == this.configuration) {
                return this.views.keySet().toArray();
            }
            if (object instanceof AssemblyModule) {
                AssemblyModule module = (AssemblyModule)object;
                CDOView view = this.views.get(module);
                CDOResource rootResource = view.getRootResource();
                return rootResource.getContents().toArray();
            }
            if (object instanceof CDOResourceFolder) {
                CDOResourceFolder folder = (CDOResourceFolder)object;
                return folder.getNodes().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object object) {
            if (object instanceof CDOResourceNode) {
                CDOResourceNode node = (CDOResourceNode)object;
                if (node.isRoot()) {
                    CDOView view = node.cdoView();
                    for (Map.Entry<AssemblyModule, CDOView> entry : this.views.entrySet()) {
                        if (entry.getValue() != view) continue;
                        return entry.getKey();
                    }
                    return null;
                }
                return node.getFolder();
            }
            if (object instanceof AssemblyModule) {
                return this.configuration;
            }
            return super.getParent(object);
        }

        protected Object adapt(Object target, Object type) {
            return this.adapterFactory.adapt(target, type);
        }

        protected Object[] modifyChildren(Object parent, Object[] children) {
            return children;
        }

        protected ITreeContentProvider getContentProvider(Object object) {
            return this.delegate;
        }

        protected RunnableViewerRefresh getViewerRefresh() {
            return this.delegate.getViewerRefresh();
        }
    }

    private static final class ModuleResourcesLabelProvider
    extends AdapterFactoryLabelProvider {
        public ModuleResourcesLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public String getText(Object object) {
            if (object instanceof AssemblyModule) {
                AssemblyModule module = (AssemblyModule)object;
                return String.valueOf(module.getName()) + " " + module.getVersion();
            }
            return super.getText(object);
        }
    }
}

