/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.editor;

import java.util.List;
import org.eclipse.emf.cdo.ui.CDOLoadResourceProvider;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.widgets.CompositeFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class CDOLoadResourceAction
extends LoadResourceAction {
    public CDOLoadResourceAction() {
    }

    public CDOLoadResourceAction(EditingDomain domain) {
        super(domain);
    }

    public void run() {
        CDOLoadResourceDialog dialog = new CDOLoadResourceDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.domain);
        dialog.open();
    }

    public static class CDOLoadResourceDialog
    extends LoadResourceAction.LoadResourceDialog {
        public CDOLoadResourceDialog(Shell parent, EditingDomain domain) {
            super(parent, domain);
        }

        protected Control createDialogArea(Composite parent) {
            final Shell shell = this.getShell();
            final boolean multi = this.isMulti();
            final ResourceSet resourceSet = this.domain.getResourceSet();
            List<CDOLoadResourceProvider> providers = CDOLoadResourceProvider.Factory.getProviders((IManagedContainer)IPluginContainer.INSTANCE, resourceSet);
            GridLayout areaLayout = new GridLayout();
            areaLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
            areaLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            areaLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            areaLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            areaLayout.numColumns = 2 + (EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE ? 1 : 0) + providers.size();
            Composite composite = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layout((Layout)areaLayout)).layoutData((Object)new GridData(1808))).create((Widget)parent);
            CDOLoadResourceDialog.applyDialogFont((Control)composite);
            Label resourceURILabel = new Label(composite, 16384);
            resourceURILabel.setText(CommonUIPlugin.INSTANCE.getString(multi ? "_UI_ResourceURIs_label" : "_UI_ResourceURI_label"));
            resourceURILabel.setLayoutData((Object)GridDataFactory.fillDefaults().align(16384, 0x1000000).create());
            Button browseFileSystemButton = new Button(composite, 8);
            browseFileSystemButton.setText(CommonUIPlugin.INSTANCE.getString("_UI_BrowseFileSystem_label"));
            browseFileSystemButton.setLayoutData((Object)GridDataFactory.fillDefaults().create());
            this.prepareBrowseFileSystemButton(browseFileSystemButton);
            if (EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE) {
                Button browseWorkspaceButton = new Button(composite, 8);
                browseWorkspaceButton.setText(CommonUIPlugin.INSTANCE.getString("_UI_BrowseWorkspace_label"));
                browseWorkspaceButton.setLayoutData((Object)GridDataFactory.fillDefaults().create());
                this.prepareBrowseWorkspaceButton(browseWorkspaceButton);
            }
            for (final CDOLoadResourceProvider provider : providers) {
                Button button = new Button(composite, 8);
                button.setText(provider.getButtonText(resourceSet));
                button.setLayoutData((Object)GridDataFactory.fillDefaults().create());
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        List<URI> uris = provider.browseResources(resourceSet, shell, multi);
                        if (ObjectUtil.isEmpty(uris)) {
                            return;
                        }
                        if (multi) {
                            StringBuilder builder = new StringBuilder();
                            for (URI uri : uris) {
                                builder.append(uri.toString());
                                builder.append("  ");
                            }
                            uriField.setText((String.valueOf(uriField.getText()) + "  " + builder.toString()).trim());
                        } else {
                            uriField.setText(uris.get(0).toString());
                        }
                    }
                });
            }
            this.uriField = new Text(composite, 2048);
            this.uriField.setLayoutData((Object)GridDataFactory.fillDefaults().span(areaLayout.numColumns, 1).grab(true, false).create());
            Label separatorLabel = new Label(parent, 258);
            separatorLabel.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
            return composite;
        }
    }
}

