/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.buddies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.net4j.buddies.common.IAccount;
import org.eclipse.net4j.buddies.common.IBuddy;
import org.eclipse.net4j.buddies.common.ICollaboration;
import org.eclipse.net4j.buddies.common.IMembership;
import org.eclipse.net4j.buddies.common.ISession;
import org.eclipse.net4j.buddies.internal.common.Buddy;
import org.eclipse.net4j.buddies.internal.common.Membership;
import org.eclipse.net4j.internal.buddies.BuddyCollaboration;
import org.eclipse.net4j.internal.buddies.ClientSession;
import org.eclipse.net4j.internal.buddies.protocol.InitiateCollaborationRequest;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public class Self
extends Buddy {
    private IAccount account;

    protected Self(ClientSession session, IAccount account, Set<String> facilityTypes) {
        super((ISession)session, facilityTypes);
        this.account = account;
    }

    public ClientSession getSession() {
        return (ClientSession)super.getSession();
    }

    public String getUserID() {
        return this.account.getUserID();
    }

    public IAccount getAccount() {
        return this.account;
    }

    public IMembership[] initiate(Collection<IBuddy> buddies) {
        try {
            ClientSession session = this.getSession();
            long id = (Long)new InitiateCollaborationRequest(session.getProtocol(), buddies).send(5000L);
            BuddyCollaboration collaboration = new BuddyCollaboration(session, id);
            collaboration.activate();
            Membership.create((IBuddy)this, (ICollaboration)collaboration);
            ArrayList<IMembership> memberships = new ArrayList<IMembership>();
            for (IBuddy buddy : buddies) {
                IMembership membership = Membership.create((IBuddy)buddy, (ICollaboration)collaboration);
                memberships.add(membership);
            }
            return memberships.toArray(new IMembership[memberships.size()]);
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    public IMembership join(long collaborationID) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public IMembership join(Object invitationToken) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    protected void doDeactivate() throws Exception {
        IMembership[] iMembershipArray = this.getMemberships();
        int n = iMembershipArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMembership membership = iMembershipArray[n2];
            LifecycleUtil.deactivate((Object)membership.getCollaboration());
            ++n2;
        }
        super.doDeactivate();
    }
}

