/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.lm.LMFactory;
import org.eclipse.emf.cdo.lm.LMPackage;
import org.eclipse.emf.cdo.lm.Stream;
import org.eclipse.emf.cdo.lm.provider.FloatingBaselineItemProvider;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.net4j.util.StringUtil;

public class StreamItemProvider
extends FloatingBaselineItemProvider {
    public StreamItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addBasePropertyDescriptor(object);
            this.addStartTimeStampPropertyDescriptor(object);
            this.addMajorVersionPropertyDescriptor(object);
            this.addMinorVersionPropertyDescriptor(object);
            this.addCodeNamePropertyDescriptor(object);
            this.addAllowedChangesPropertyDescriptor(object);
            this.addModePropertyDescriptor(object);
            this.addDevelopmentBranchPropertyDescriptor(object);
            this.addMaintenanceBranchPropertyDescriptor(object);
            this.addMaintenanceTimeStampPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addBasePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Stream_base_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Stream_base_feature", "_UI_Stream_type"), (EStructuralFeature)LMPackage.Literals.STREAM__BASE, true, false, true, null, null, null));
    }

    protected void addStartTimeStampPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Stream_startTimeStamp_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Stream_startTimeStamp_feature", "_UI_Stream_type"), (EStructuralFeature)LMPackage.Literals.STREAM__START_TIME_STAMP, true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addMajorVersionPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Stream_majorVersion_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Stream_majorVersion_feature", "_UI_Stream_type"), (EStructuralFeature)LMPackage.Literals.STREAM__MAJOR_VERSION, true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addMinorVersionPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Stream_minorVersion_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Stream_minorVersion_feature", "_UI_Stream_type"), (EStructuralFeature)LMPackage.Literals.STREAM__MINOR_VERSION, true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addCodeNamePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Stream_codeName_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Stream_codeName_feature", "_UI_Stream_type"), (EStructuralFeature)LMPackage.Literals.STREAM__CODE_NAME, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addAllowedChangesPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Stream_allowedChanges_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Stream_allowedChanges_feature", "_UI_Stream_type"), (EStructuralFeature)LMPackage.Literals.STREAM__ALLOWED_CHANGES, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addModePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Stream_mode_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Stream_mode_feature", "_UI_Stream_type"), (EStructuralFeature)LMPackage.Literals.STREAM__MODE, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addDevelopmentBranchPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Stream_developmentBranch_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Stream_developmentBranch_feature", "_UI_Stream_type"), (EStructuralFeature)LMPackage.Literals.STREAM__DEVELOPMENT_BRANCH, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addMaintenanceBranchPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Stream_maintenanceBranch_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Stream_maintenanceBranch_feature", "_UI_Stream_type"), (EStructuralFeature)LMPackage.Literals.STREAM__MAINTENANCE_BRANCH, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addMaintenanceTimeStampPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Stream_maintenanceTimeStamp_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Stream_maintenanceTimeStamp_feature", "_UI_Stream_type"), (EStructuralFeature)LMPackage.Literals.STREAM__MAINTENANCE_TIME_STAMP, true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(LMPackage.Literals.STREAM__CONTENTS);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Stream"));
    }

    @Override
    protected boolean shouldComposeCreationImage() {
        return true;
    }

    @Override
    public String getText(Object object) {
        Stream stream = (Stream)object;
        String label = String.valueOf(stream.getMajorVersion()) + "." + stream.getMinorVersion();
        String codeName = stream.getCodeName();
        if (!StringUtil.isEmpty((String)codeName)) {
            label = String.valueOf(label) + " " + codeName;
        }
        switch (stream.getMode()) {
            case DEVELOPMENT: {
                break;
            }
            case MAINTENANCE: {
                label = String.valueOf(label) + " (maintenance)";
                break;
            }
            case CLOSED: {
                label = String.valueOf(label) + " (closed)";
            }
        }
        return label;
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Stream.class)) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 14: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(LMPackage.Literals.STREAM__CONTENTS, LMFactory.eINSTANCE.createStream()));
        newChildDescriptors.add(this.createChildParameter(LMPackage.Literals.STREAM__CONTENTS, LMFactory.eINSTANCE.createChange()));
        newChildDescriptors.add(this.createChildParameter(LMPackage.Literals.STREAM__CONTENTS, LMFactory.eINSTANCE.createDelivery()));
        newChildDescriptors.add(this.createChildParameter(LMPackage.Literals.STREAM__CONTENTS, LMFactory.eINSTANCE.createDrop()));
    }
}

