/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts.wizards;

import java.util.HashSet;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.explorer.ui.checkouts.wizards.CheckoutNodeWizardPage;
import org.eclipse.emf.cdo.explorer.ui.checkouts.wizards.NewWizard;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class NewWizardPage
extends CheckoutNodeWizardPage {
    private final String resourceType;
    private Text nameText;
    private boolean nameModified;
    private String name;

    public NewWizardPage(String resourceType, String title, IStructuredSelection selection) {
        super("NewPage", title, selection);
        this.resourceType = resourceType;
    }

    public NewWizard getWizard() {
        return (NewWizard)super.getWizard();
    }

    public final String getName() {
        return this.name;
    }

    @Override
    protected String getNodeMessage() {
        return "Select the parent folder";
    }

    @Override
    protected void doCreateControl(Composite parent) {
        this.setImageDescriptor(OM.getImageDescriptor("icons/wiz/new_" + this.resourceType + ".gif"));
        this.setMessage("Enter the name of the " + this.title.toLowerCase() + ".");
        super.doCreateControl(parent);
        Label nameLabel = new Label(parent, 0);
        nameLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        nameLabel.setText("Name:");
        this.nameText = new Text(parent, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.nameText.addModifyListener(e -> {
            this.nameModified = true;
            this.validate();
        });
    }

    @Override
    protected void deferredInit() {
        super.deferredInit();
        if (this.getNode() != null) {
            this.nameText.setFocus();
        } else {
            this.getControl().getParent().setFocus();
        }
        this.nameText.selectAll();
    }

    @Override
    protected void doValidate() throws Exception {
        super.doValidate();
        String name = this.nameText.getText();
        if (!this.nameModified) {
            name = this.getUniqueName();
            this.nameText.setText(name);
        } else {
            name.length();
            if (!this.isUnique(name)) {
                throw new Exception("Name is not unique within the parent folder.");
            }
            this.name = name;
        }
    }

    private String getUniqueName() {
        HashSet<String> names = new HashSet<String>();
        for (EObject eObject : this.getNodeChildren()) {
            CDOResourceNode node;
            String name;
            if (!(eObject instanceof CDOResourceNode) || !(name = (node = (CDOResourceNode)eObject).getName()).startsWith(this.resourceType)) continue;
            names.add(name);
        }
        int i = 1;
        while (i < Integer.MAX_VALUE) {
            String name = String.valueOf(this.resourceType) + i;
            if (!names.contains(name)) {
                return name;
            }
            ++i;
        }
        throw new IllegalStateException("Too many children");
    }

    private boolean isUnique(String name) {
        for (EObject eObject : this.getNodeChildren()) {
            CDOResourceNode node;
            if (!(eObject instanceof CDOResourceNode) || !ObjectUtil.equals((Object)(node = (CDOResourceNode)eObject).getName(), (Object)name)) continue;
            return false;
        }
        return true;
    }
}

