/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.buddies.internal.chat;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.net4j.buddies.chat.IChat;
import org.eclipse.net4j.buddies.chat.IComment;
import org.eclipse.net4j.buddies.common.IMessage;
import org.eclipse.net4j.buddies.internal.chat.Comment;
import org.eclipse.net4j.buddies.internal.chat.CommentEvent;
import org.eclipse.net4j.buddies.internal.chat.TextMessage;
import org.eclipse.net4j.buddies.spi.common.Facility;
import org.eclipse.net4j.util.event.IListener;

public class Chat
extends Facility
implements IChat {
    private List<IComment> comments = new ArrayList<IComment>();

    public Chat() {
        super("chat");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IComment[] getComments() {
        List<IComment> list = this.comments;
        synchronized (list) {
            return this.comments.toArray(new IComment[this.comments.size()]);
        }
    }

    @Override
    public void sendComment(String text) {
        TextMessage message = new TextMessage(text);
        this.sendMessage((IMessage)message);
        this.addComment(message.getSenderID(), text);
    }

    public void handleMessage(IMessage message) {
        if (message instanceof TextMessage) {
            this.addComment(message.getSenderID(), ((TextMessage)message).getText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addComment(String senderID, String text) {
        Comment comment = new Comment(System.currentTimeMillis(), senderID, text);
        List<IComment> list = this.comments;
        synchronized (list) {
            this.comments.add(comment);
        }
        IListener[] listeners = this.getListeners();
        if (listeners.length != 0) {
            this.fireEvent(new CommentEvent(this, comment), listeners);
        }
    }
}

