/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.repositories.wizards;

import java.util.Properties;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.explorer.ui.checkouts.wizards.CheckoutWizardPage;
import org.eclipse.emf.cdo.explorer.ui.repositories.wizards.NewRepositoryWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.net4j.util.security.IPasswordCredentials;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractRepositoryPage
extends WizardPage
implements SelectionListener,
ModifyListener {
    private final String defaultLabel;
    private Text labelText;
    private Properties properties;

    public AbstractRepositoryPage(String pageName, String defaultLabel) {
        super(pageName);
        this.setImageDescriptor(OM.getImageDescriptor("icons/wiz/new_repo.gif"));
        this.defaultLabel = CDOExplorerUtil.getRepositoryManager().getUniqueLabel(defaultLabel);
    }

    public NewRepositoryWizard getWizard() {
        return (NewRepositoryWizard)super.getWizard();
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public IPasswordCredentials getCredentials() {
        return null;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout containerGridLayout = new GridLayout();
        containerGridLayout.numColumns = 2;
        container.setLayout((Layout)containerGridLayout);
        this.setControl((Control)container);
        AbstractRepositoryPage.createLabel(container, "Label:");
        this.labelText = new Text(container, 2048);
        this.labelText.setText(this.defaultLabel);
        this.labelText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.labelText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractRepositoryPage.this.validate();
            }
        });
        this.fillPage(container);
        this.setPreviousPage((IWizardPage)this.getWizard().getTypePage());
        this.validate();
    }

    public void modifyText(ModifyEvent e) {
        this.validate();
    }

    public void widgetSelected(SelectionEvent e) {
        this.validate();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.validate();
    }

    protected final void validate() {
        this.properties = new Properties();
        this.properties.setProperty("type", this.getName());
        try {
            this.doValidate(this.properties);
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
        catch (Exception ex) {
            this.properties = null;
            this.setErrorMessage(ex.getMessage());
            this.setPageComplete(false);
        }
    }

    protected void doValidate(Properties properties) throws Exception {
        String label = this.labelText.getText();
        if (label.length() == 0) {
            throw new CheckoutWizardPage.ValidationProblem("Label is empty.");
        }
        int i = 0;
        while (i < label.length()) {
            char c = label.charAt(i);
            int j = 0;
            while (j < "/\\:;,".length()) {
                if (c == "/\\:;,".charAt(j)) {
                    throw new CheckoutWizardPage.ValidationProblem("Invalid character: " + "/\\:;,".substring(j, 1));
                }
                ++j;
            }
            ++i;
        }
        if (CDOExplorerUtil.getRepositoryManager().getRepositoryByLabel(label) != null) {
            throw new CheckoutWizardPage.ValidationProblem("Label is not unique.");
        }
        properties.setProperty("label", label);
    }

    protected abstract void fillPage(Composite var1);

    public static Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(131072, 128, false, false));
        label.setText(text);
        return label;
    }

    public static Text createText(Composite container, int widthHint) {
        GridData gridData = new GridData(16384, 0x1000000, false, false);
        gridData.widthHint = widthHint;
        Text text = new Text(container, 2048);
        text.setLayoutData((Object)gridData);
        return text;
    }
}

