/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.tests.bugzilla;

import java.nio.BufferUnderflowException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.jvm.JVMUtil;
import org.eclipse.net4j.signal.IndicationWithResponse;
import org.eclipse.net4j.signal.RequestWithConfirmation;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.signal.SignalReactor;
import org.eclipse.net4j.util.IErrorHandler;
import org.eclipse.net4j.util.concurrent.Worker;
import org.eclipse.net4j.util.container.ContainerUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.tests.AbstractOMTest;
import org.eclipse.spi.net4j.ServerProtocolFactory;

public class Bugzilla_262875_Test
extends AbstractOMTest {
    private static final short BUFFER_METADATA_LENTGH = 10;
    private IManagedContainer container;
    private IConnector connector;

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.container = ContainerUtil.createContainer();
        Net4jUtil.prepareContainer((IManagedContainer)this.container);
        JVMUtil.prepareContainer((IManagedContainer)this.container);
        this.container.registerFactory((IFactory)new TestProtocol.Factory());
        this.container.activate();
        JVMUtil.getAcceptor((IManagedContainer)this.container, (String)"default");
        this.connector = JVMUtil.getConnector((IManagedContainer)this.container, (String)"default");
    }

    @Override
    protected void doTearDown() throws Exception {
        this.connector.close();
        this.container.deactivate();
        super.doTearDown();
    }

    public void testGivenDataMatchesBufferLengthThenBufferUnderflowException() throws Exception {
        final AtomicBoolean failed = new AtomicBoolean(false);
        final CountDownLatch latch = new CountDownLatch(1);
        IErrorHandler oldErrorHandler = Worker.setGlobalErrorHandler((IErrorHandler)new IErrorHandler(){

            public void handleError(Throwable t) {
                t.printStackTrace();
                if (t instanceof BufferUnderflowException) {
                    failed.set(true);
                }
                latch.countDown();
            }
        });
        try {
            TestProtocol protocol = new TestProtocol();
            protocol.open(this.connector);
            short bufferCapacity = protocol.getBufferProvider().getBufferCapacity();
            new TestProtocol.Request(protocol, bufferCapacity - 10).send();
            latch.await(3000L, TimeUnit.MILLISECONDS);
            Bugzilla_262875_Test.assertEquals((boolean)false, (boolean)failed.get());
        }
        finally {
            Worker.setGlobalErrorHandler((IErrorHandler)oldErrorHandler);
        }
    }

    private static final class TestProtocol
    extends SignalProtocol<Object> {
        private static final String NAME = "TEST_PROTOCOL";
        private static final short SIGNAL_ID = 10;

        public TestProtocol() {
            super(NAME);
        }

        protected SignalReactor createSignalReactor(short signalID) {
            switch (signalID) {
                case 10: {
                    return new Indication(this);
                }
            }
            return super.createSignalReactor(signalID);
        }

        private static final class Factory
        extends ServerProtocolFactory {
            public Factory() {
                super(TestProtocol.NAME);
            }

            public Object create(String description) throws ProductCreationException {
                return new TestProtocol();
            }
        }

        private static final class Indication
        extends IndicationWithResponse {
            public Indication(SignalProtocol<?> protocol) {
                super(protocol, (short)10);
            }

            protected void indicating(ExtendedDataInputStream in) throws Exception {
                System.out.println("indicating");
            }

            protected void responding(ExtendedDataOutputStream out) throws Exception {
                out.writeBoolean(true);
            }
        }

        private static final class Request
        extends RequestWithConfirmation<Boolean> {
            private int requestNumOfBytes;

            public Request(SignalProtocol<?> protocol, int requestNumOfBytes) {
                super(protocol, (short)10);
                this.requestNumOfBytes = requestNumOfBytes;
            }

            protected void requesting(ExtendedDataOutputStream out) throws Exception {
                int i = 0;
                while (i < this.requestNumOfBytes) {
                    out.writeByte(i);
                    ++i;
                }
                Thread.sleep(100L);
            }

            protected Boolean confirming(ExtendedDataInputStream in) throws Exception {
                return in.readBoolean();
            }
        }
    }
}

