/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.jms.internal.server.protocol;

import org.eclipse.net4j.jms.internal.server.Server;
import org.eclipse.net4j.jms.internal.server.ServerConnection;
import org.eclipse.net4j.jms.internal.server.bundle.OM;
import org.eclipse.net4j.jms.internal.server.messages.Messages;
import org.eclipse.net4j.jms.internal.server.protocol.JMSServerProtocol;
import org.eclipse.net4j.signal.IndicationWithResponse;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;

public class JMSLogonIndication
extends IndicationWithResponse {
    private boolean ok;

    public JMSLogonIndication(JMSServerProtocol protocol) {
        super((SignalProtocol)protocol, (short)2);
    }

    protected void indicating(ExtendedDataInputStream in) throws Exception {
        String password;
        String userName = in.readString();
        ServerConnection connection = Server.INSTANCE.logon(userName, password = in.readString());
        if (connection == null) {
            OM.LOG.error(Messages.getString("JMSLogonIndication_0"));
            return;
        }
        JMSServerProtocol protocol = (JMSServerProtocol)this.getProtocol();
        connection.setProtocol(protocol);
        protocol.setInfraStructure(connection);
        this.ok = true;
    }

    protected void responding(ExtendedDataOutputStream out) throws Exception {
        out.writeBoolean(this.ok);
    }
}

