/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.examples.server.offline;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.util.RepositoryStateChangedEvent;
import org.eclipse.emf.cdo.common.util.RepositoryTypeChangedEvent;
import org.eclipse.emf.cdo.examples.company.CompanyPackage;
import org.eclipse.emf.cdo.examples.server.offline.OfflineExampleUtil;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.net4j.acceptor.IAcceptor;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.db.h2.H2Adapter;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.log.OMLogHandler;
import org.eclipse.net4j.util.om.log.PrintLogHandler;
import org.h2.jdbcx.JdbcDataSource;

public abstract class AbstractOfflineExampleServer {
    public static final String TRANSPORT_TYPE = "tcp";
    protected int port;
    protected String name;
    protected transient IManagedContainer container;
    protected transient IRepository repository;
    protected transient IAcceptor acceptor;

    static {
        OMPlatform.INSTANCE.addLogHandler((OMLogHandler)PrintLogHandler.CONSOLE);
        CompanyPackage.eINSTANCE.getClass();
    }

    public AbstractOfflineExampleServer(String name, int port, int dbBrowserPort) {
        this.name = name;
        this.port = port;
        this.container = OfflineExampleUtil.createContainer();
        this.container.getElement("org.eclipse.emf.cdo.server.browsers", "default", String.valueOf(dbBrowserPort));
    }

    public void init() {
        IStore store = this.createStore();
        Map<String, String> props = this.createProperties();
        this.repository = this.createRepository(store, props);
        CDOServerUtil.addRepository((IManagedContainer)this.container, (IRepository)this.repository);
        this.repository.addListener(new IListener(){

            public void notifyEvent(IEvent event) {
                if (event instanceof RepositoryTypeChangedEvent) {
                    RepositoryTypeChangedEvent e = (RepositoryTypeChangedEvent)event;
                    System.out.println("Type changed from " + e.getOldType() + " to " + e.getNewType());
                } else if (event instanceof RepositoryStateChangedEvent) {
                    RepositoryStateChangedEvent e = (RepositoryStateChangedEvent)event;
                    System.out.println("State changed from " + e.getOldState() + " to " + e.getNewState());
                }
            }
        });
        this.repository.getSessionManager().addListener((IListener)new ContainerEventAdapter<ISession>(){

            protected void onAdded(IContainer<ISession> sessionManager, ISession session) {
                System.out.println("Registered " + session);
            }

            protected void onRemoved(IContainer<ISession> sessionManager, ISession session) {
                System.out.println("Unregistered " + session);
            }
        });
        this.connect();
    }

    public void run() throws Exception {
        String command;
        do {
            System.out.println();
            System.out.println("Enter a command:");
            this.showMenu();
            System.out.println();
        } while (!this.handleCommand(command = new BufferedReader(new InputStreamReader(System.in)).readLine()));
    }

    public void done() {
        LifecycleUtil.deactivate((Object)this.acceptor);
        LifecycleUtil.deactivate((Object)this.repository);
        this.container.deactivate();
    }

    protected void showMenu() {
        System.out.println("0 - exit");
        System.out.println("1 - connect repository to network");
        System.out.println("2 - disconnect repository from network");
        System.out.println("3 - dump repository infos");
    }

    protected boolean handleCommand(String command) {
        if ("1".equals(command)) {
            if (this.acceptor == null) {
                this.connect();
            } else {
                System.out.println("Already connected");
            }
        } else if ("2".equals(command)) {
            if (this.acceptor != null) {
                this.disconnect();
            } else {
                System.out.println("Already disconnected");
            }
        } else if ("3".equals(command)) {
            System.out.println();
            System.out.println(String.valueOf(this.repository.getName()) + ": " + this.repository.getType() + (this.repository.getType() == CDOCommonRepository.Type.BACKUP ? "|" + this.repository.getState() : ""));
        } else {
            if ("0".equals(command)) {
                System.out.println("Exiting...");
                return true;
            }
            System.out.println("Unknown command");
        }
        return false;
    }

    protected void connect() {
        System.out.println("Connecting to network...");
        this.acceptor = this.createAcceptor();
        System.out.println("Connected");
    }

    protected IAcceptor createAcceptor() {
        return (IAcceptor)this.container.getElement("org.eclipse.net4j.acceptors", TRANSPORT_TYPE, "0.0.0.0:" + this.port);
    }

    protected void disconnect() {
        System.out.println("Disconnecting from network...");
        LifecycleUtil.deactivate((Object)this.acceptor);
        this.acceptor = null;
        System.out.println("Disconnected");
    }

    protected IStore createStore() {
        JdbcDataSource dataSource = new JdbcDataSource();
        dataSource.setURL("jdbc:h2:database/" + this.name);
        IMappingStrategy mappingStrategy = CDODBUtil.createHorizontalMappingStrategy((boolean)true, (boolean)true);
        H2Adapter dbAdapter = new H2Adapter();
        IDBConnectionProvider dbConnectionProvider = dbAdapter.createConnectionProvider((DataSource)dataSource);
        return CDODBUtil.createStore((IMappingStrategy)mappingStrategy, (IDBAdapter)dbAdapter, (IDBConnectionProvider)dbConnectionProvider);
    }

    protected Map<String, String> createProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("overrideUUID", this.name);
        props.put("supportingAudits", "true");
        props.put("supportingBranches", "true");
        return props;
    }

    protected abstract IRepository createRepository(IStore var1, Map<String, String> var2);
}

