/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.derby.impl.drda.DDMReader;
import org.apache.derby.impl.drda.DRDAProtocolException;
import org.apache.derby.impl.drda.EXTDTAReaderInputStream;

final class LayerBStreamedEXTDTAReaderInputStream
extends EXTDTAReaderInputStream {
    private final DDMReader reader;
    private ByteArrayInputStream currentBuffer;

    LayerBStreamedEXTDTAReaderInputStream(DDMReader dDMReader, boolean bl) throws DRDAProtocolException {
        super(true, bl);
        this.reader = dDMReader;
        this.currentBuffer = dDMReader.readLOBInitStream();
    }

    @Override
    public final int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray);
        return n == 1 ? byArray[0] : -1;
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.currentBuffer == null) {
            return -1;
        }
        if (this.reader.doingLayerBStreaming()) {
            n3 = this.currentBuffer.read(byArray, n, n2);
            if (this.currentBuffer.available() == 0) {
                this.currentBuffer = this.reader.readLOBContinuationStream();
            }
        } else if (this.readStatusByte) {
            int n4 = this.currentBuffer.available() - 1;
            n3 = this.currentBuffer.read(byArray, n, Math.min(n4, n2));
            if (n4 == 0) {
                this.checkStatus(this.currentBuffer.read());
                n3 = -1;
                this.currentBuffer = null;
            } else if (n4 == n3) {
                this.checkStatus(this.currentBuffer.read());
                this.currentBuffer = null;
            }
        } else {
            n3 = this.currentBuffer.read(byArray, n, n2);
            if (this.currentBuffer.available() == 0) {
                this.currentBuffer = null;
            }
        }
        return n3;
    }

    @Override
    public final int available() {
        int n = 0;
        if (this.currentBuffer != null) {
            n = this.currentBuffer.available();
            if (this.readStatusByte && !this.reader.doingLayerBStreaming()) {
                --n;
            }
        }
        return n;
    }

    @Override
    protected void onClientSideStreamingError() {
        this.currentBuffer = null;
    }
}

