/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.security;

public enum CDOPermission {
    NONE(0),
    READ(1),
    WRITE(3);

    private byte bits;

    private CDOPermission(int bits) {
        this.bits = (byte)bits;
    }

    public byte getBits() {
        return this.bits;
    }

    public boolean isReadable() {
        return this != NONE;
    }

    public boolean isWritable() {
        return this == WRITE;
    }

    public static CDOPermission get(int bits) {
        switch (bits &= WRITE.getBits()) {
            case 0: {
                return NONE;
            }
            case 1: {
                return READ;
            }
            case 3: {
                return WRITE;
            }
        }
        throw new IllegalArgumentException("Invalid bits: " + bits);
    }
}

