/*
 * Decompiled with CFR 0.152.
 */
package org.gastro.business;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum OrderState implements Enumerator
{
    ORDERED(0, "Ordered", "Ordered"),
    ACKNOWLEDGED(2, "Acknowledged", "Acknowledged"),
    PREPARED(1, "Prepared", "Prepared"),
    SERVED(3, "Served", "Served"),
    PAID(4, "Paid", "Paid");

    public static final int ORDERED_VALUE = 0;
    public static final int ACKNOWLEDGED_VALUE = 2;
    public static final int PREPARED_VALUE = 1;
    public static final int SERVED_VALUE = 3;
    public static final int PAID_VALUE = 4;
    private static final OrderState[] VALUES_ARRAY;
    public static final List<OrderState> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new OrderState[]{ORDERED, ACKNOWLEDGED, PREPARED, SERVED, PAID};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static OrderState get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OrderState result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OrderState getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OrderState result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OrderState get(int value) {
        switch (value) {
            case 0: {
                return ORDERED;
            }
            case 2: {
                return ACKNOWLEDGED;
            }
            case 1: {
                return PREPARED;
            }
            case 3: {
                return SERVED;
            }
            case 4: {
                return PAID;
            }
        }
        return null;
    }

    private OrderState(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

