/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtbase.utilities;

import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Import;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.pivot.utilities.ToStringVisitor;
import org.eclipse.qvtd.pivot.qvtbase.BaseModel;
import org.eclipse.qvtd.pivot.qvtbase.CompoundTargetElement;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.FunctionBody;
import org.eclipse.qvtd.pivot.qvtbase.FunctionParameter;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.QVTbasePackage;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.SimpleTargetElement;
import org.eclipse.qvtd.pivot.qvtbase.Target;
import org.eclipse.qvtd.pivot.qvtbase.TargetElement;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.util.QVTbaseVisitor;

public class QVTbaseToStringVisitor
extends ToStringVisitor
implements QVTbaseVisitor<String> {
    public static // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ToStringVisitor.Factory FACTORY = new QVTbaseToStringFactory();

    public QVTbaseToStringVisitor(@NonNull StringBuilder s) {
        super(s);
    }

    @Override
    public String visitBaseModel(@NonNull BaseModel object) {
        this.append("base model ");
        return null;
    }

    @Override
    public String visitCompoundTargetElement(@NonNull CompoundTargetElement object) {
        this.append("{ ");
        for (TargetElement targetElement : object.getOwnedTargetElements()) {
            this.safeVisit((Visitable)targetElement);
            this.append("; ");
        }
        this.append("}");
        return null;
    }

    @Override
    public String visitDomain(@NonNull Domain object) {
        this.appendQualifiedName(object);
        return null;
    }

    @Override
    public String visitFunction(@NonNull Function object) {
        return this.visitOperation(object);
    }

    @Override
    public String visitFunctionBody(@NonNull FunctionBody object) {
        return super.visitExpressionInOCL((ExpressionInOCL)object);
    }

    @Override
    public String visitFunctionParameter(@NonNull FunctionParameter object) {
        return this.visitParameter(object);
    }

    public String visitImport(@NonNull Import object) {
        this.append("import ");
        this.appendName((Nameable)object);
        return null;
    }

    public String visitOperationCallExp(@NonNull OperationCallExp object) {
        Operation oper = object.getReferredOperation();
        if (!(oper instanceof Function)) {
            return super.visitOperationCallExp(object);
        }
        this.appendName((Nameable)oper);
        this.append("(");
        String prefix = "";
        for (OCLExpression argument : object.getOwnedArguments()) {
            this.append(prefix);
            this.safeVisit((Visitable)argument);
            prefix = ", ";
        }
        this.append(")");
        return null;
    }

    @Override
    public String visitPattern(@NonNull Pattern object) {
        boolean isFirst = true;
        for (Predicate predicate : object.getPredicate()) {
            if (!isFirst) {
                this.append(" ");
            }
            this.safeVisit((Visitable)predicate);
            isFirst = false;
        }
        return null;
    }

    @Override
    public String visitPredicate(@NonNull Predicate object) {
        this.safeVisit((Visitable)object.getConditionExpression());
        this.append(";");
        return null;
    }

    @Override
    public String visitRule(@NonNull Rule object) {
        this.appendQualifiedName(object);
        return null;
    }

    @Override
    public String visitSimpleTargetElement(@NonNull SimpleTargetElement object) {
        this.append(object.getKind().getName());
        this.append(" ");
        this.appendName((Nameable)object.getTypedModel());
        return null;
    }

    @Override
    public String visitTarget(@NonNull Target object) {
        this.appendName((Nameable)object);
        this.append("{ ");
        for (TargetElement targetElement : object.getOwnedTargetElements()) {
            this.safeVisit((Visitable)targetElement);
            this.append("; ");
        }
        this.append("}");
        return null;
    }

    @Override
    public String visitTargetElement(@NonNull TargetElement object) {
        return null;
    }

    @Override
    public String visitTransformation(@NonNull Transformation object) {
        this.appendQualifiedName((NamedElement)object);
        return null;
    }

    @Override
    public String visitTypedModel(@NonNull TypedModel object) {
        this.appendName((Nameable)object);
        return null;
    }

    protected static class QVTbaseToStringFactory
    implements ToStringVisitor.Factory {
        protected QVTbaseToStringFactory() {
            ToStringVisitor.addFactory((ToStringVisitor.Factory)this);
            ToStringVisitor.FACTORY.getClass();
        }

        public @NonNull ToStringVisitor createToStringVisitor(@NonNull StringBuilder s) {
            return new QVTbaseToStringVisitor(s);
        }

        public @NonNull EPackage getEPackage() {
            QVTbasePackage eInstance = QVTbasePackage.eINSTANCE;
            assert (eInstance != null);
            return eInstance;
        }
    }
}

