/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.CompilerProblem;

public class CompilerProblems {
    private List<@NonNull CompilerProblem> errors = null;
    private List<@NonNull CompilerProblem> infos = null;
    private List<@NonNull CompilerProblem> warnings = null;

    public void addProblem(@NonNull CompilerProblem problem) {
        List<@NonNull CompilerProblem> problems = null;
        switch (problem.getSeverity()) {
            case ERROR: {
                if (this.errors == null) {
                    this.errors = new ArrayList<CompilerProblem>();
                }
                problems = this.errors;
                System.err.println(problem);
                break;
            }
            case INFO: {
                if (this.infos == null) {
                    this.infos = new ArrayList<CompilerProblem>();
                }
                problems = this.infos;
                System.out.println(problem);
                break;
            }
            case WARNING: {
                if (this.warnings == null) {
                    this.warnings = new ArrayList<CompilerProblem>();
                }
                problems = this.warnings;
                System.out.println(problem);
            }
        }
        assert (problems != null);
        problems.add(problem);
    }

    public void throwCompilerChainExceptionForErrors() throws CompilerChainException {
        if (this.errors != null) {
            throw new CompilerChainException(String.valueOf(this.errors), new Object[0]);
        }
        if (this.warnings != null) {
            throw new CompilerChainException(String.valueOf(this.warnings), new Object[0]);
        }
    }
}

