/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtbase.graphs;

import java.util.Stack;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class XMLStringBuilder {
    private StringBuilder s = new StringBuilder();
    private @NonNull Stack<String> tagStack = new Stack();
    private @Nullable String currentTag = null;

    public void appendElement(@NonNull String element, String value) {
        this.s.append(" ");
        this.s.append(element);
        this.s.append("=\"");
        this.s.append(value);
        this.s.append("\"");
    }

    protected void appendIndentation() {
        int i = 0;
        while (i < this.tagStack.size()) {
            this.s.append("  ");
            ++i;
        }
    }

    public void appendNewLineElement(@NonNull String element, @NonNull String value) {
        this.s.append("\n");
        this.appendIndentation();
        this.appendElement(element, value);
    }

    public void appendText(@NonNull String tag, String text) {
        this.appendTextBegin(tag);
        this.appendTextEnd(text);
    }

    public void appendTextBegin(@NonNull String tag) {
        this.pushTag(tag);
    }

    public void appendTextEnd(String text) {
        this.s.append(">");
        this.s.append(text);
        this.s.append("</");
        this.s.append(this.tagStack.pop());
        this.s.append(">\n");
        this.currentTag = null;
    }

    public void appendValueAndPopTag(@Nullable String value) {
        if (this.currentTag != null) {
            this.s.append(">");
            this.currentTag = null;
        }
        if (value == null) {
            value = "";
        }
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (c == '\'') {
                this.s.append("&apos;");
            } else if (c == '\"') {
                this.s.append("&quot;");
            } else if (c == '&') {
                this.s.append("&amp;");
            } else if (c == '<') {
                this.s.append("&lt;");
            } else if (c == '>') {
                this.s.append("&gt;");
            } else if (c == '\n') {
                this.s.append("&#xA;");
            } else {
                this.s.append(c);
            }
            ++i;
        }
        String topTag = this.tagStack.pop();
        this.s.append("</");
        this.s.append(topTag);
        this.s.append(">\n");
    }

    public void popTag() {
        String topTag = this.tagStack.pop();
        if (this.currentTag != null) {
            this.s.append("/");
        } else {
            this.appendIndentation();
            this.s.append("</");
            this.s.append(topTag);
        }
        this.s.append(">\n");
        this.currentTag = null;
    }

    public void pushTag(@NonNull String tag) {
        if (this.currentTag != null) {
            this.s.append(">\n");
            this.currentTag = null;
        }
        this.appendIndentation();
        this.tagStack.push(tag);
        this.currentTag = tag;
        this.s.append("<" + tag);
    }

    public @NonNull String toString() {
        return this.s.toString();
    }
}

