/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.metrics;

import jakarta.enterprise.context.RequestScoped;
import org.eclipse.microprofile.fault.tolerance.tck.util.TestException;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;

@RequestScoped
public class CircuitBreakerMetricBean {
    @CircuitBreaker(requestVolumeThreshold=2, failureRatio=1.0, delay=1000L, successThreshold=2, failOn={TestException.class}, skipOn={SkippedException.class})
    public void doWork(Result result) {
        switch (result) {
            case PASS: {
                return;
            }
            case PASS_EXCEPTION: {
                throw new RuntimeException();
            }
            case FAIL: {
                throw new TestException();
            }
            case SKIPPED_EXCEPTION: {
                throw new SkippedException();
            }
        }
        throw new IllegalArgumentException("Unknown result requested");
    }

    public static class SkippedException
    extends TestException {
        public SkippedException() {
            super("skipped");
        }
    }

    public static enum Result {
        PASS,
        PASS_EXCEPTION,
        SKIPPED_EXCEPTION,
        FAIL;

    }
}

