/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck;

import jakarta.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.Misc;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.clientserver.CircuitBreakerClientDefaultSuccessThreshold;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CircuitBreakerLateSuccessTest
extends Arquillian {
    @Inject
    private CircuitBreakerClientDefaultSuccessThreshold clientForCBDefaultSuccess;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftCircuitBreakerLateSuccess.jar")).addClasses(new Class[]{CircuitBreakerClientDefaultSuccessThreshold.class, Misc.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftCircuitBreakerLateSuccess.war")).addAsLibrary((Archive)testJar);
    }

    @Test
    public void testCircuitLateSuccessDefaultSuccessThreshold() {
        this.clientForCBDefaultSuccess.setCounterForInvokingServiceA(0);
        for (int i = 1; i < 12; ++i) {
            int[] successSet = new int[]{4, 5, 9};
            try {
                this.clientForCBDefaultSuccess.serviceA(successSet);
                if (Misc.Ints.contains(new int[]{4, 6, 10}, i)) continue;
                Assert.fail((String)("serviceA should throw an Exception in testCircuitLateSuccessDefaultSuccessThreshold on iteration " + i));
                continue;
            }
            catch (CircuitBreakerOpenException cboe) {
                if (!Misc.Ints.contains(new int[]{5, 11}, i)) {
                    Assert.fail((String)("in serviceA no CircuitBreakerOpenException should be fired on iteration " + i));
                    continue;
                }
                if (i != 5) continue;
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            catch (RuntimeException ex) {
                if (Misc.Ints.contains(new int[]{1, 2, 3, 7, 8, 9}, i)) continue;
                Assert.fail((String)("serviceA should not throw a RuntimeException on iteration " + i));
                continue;
            }
            catch (Exception ex) {
                Assert.fail((String)("serviceA should throw a RuntimeException or CircuitBreakerOpenException in testCircuitDefaultSuccessThreshold on iteration " + i));
            }
        }
        int serviceAExecutions = this.clientForCBDefaultSuccess.getCounterForInvokingServiceA();
        Assert.assertEquals((int)serviceAExecutions, (int)9, (String)"The number of serviceA executions should be 9");
    }
}

