/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp;

import java.io.File;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class ProjectUtils {
    public static String getRelativePath(IProject project, String absolutePath) {
        File basedir = project.getLocation().toFile();
        String relative = absolutePath.equals(basedir.getAbsolutePath()) ? "." : (absolutePath.startsWith(basedir.getAbsolutePath()) ? absolutePath.substring(basedir.getAbsolutePath().length() + 1) : absolutePath);
        return relative.replace('\\', '/');
    }

    public static IPath getM2eclipseWtpFolder(MavenProject mavenProject, IProject project) {
        String buildOutputDir = mavenProject.getBuild().getDirectory();
        String relativeBuildOutputDir = ProjectUtils.getRelativePath(project, buildOutputDir);
        return new Path(relativeBuildOutputDir).append("m2e-wtp");
    }

    public static void hideM2eclipseWtpFolder(MavenProject mavenProject, IProject project) throws CoreException {
        IPath m2eclipseWtpPath = ProjectUtils.getM2eclipseWtpFolder(mavenProject, project);
        IFolder folder = project.getFolder(m2eclipseWtpPath);
        if (folder.exists()) {
            NullProgressMonitor monitor = new NullProgressMonitor();
            if (!folder.isDerived()) {
                folder.setDerived(true);
            }
            if (!folder.isHidden()) {
                folder.setHidden(true);
            }
            folder.getParent().refreshLocal(0, (IProgressMonitor)monitor);
        }
    }

    public static void createFolder(IFolder folder, IProgressMonitor monitor) throws CoreException {
        if (folder == null || folder.exists()) {
            return;
        }
        IContainer parent = folder.getParent();
        if (parent instanceof IFolder) {
            ProjectUtils.createFolder((IFolder)parent, monitor);
        }
        folder.create(true, true, monitor);
    }

    public static void removeNature(IProject project, String natureId, IProgressMonitor monitor) throws CoreException {
        if (project.hasNature(natureId)) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length - 1];
            int i = 0;
            int j = 0;
            while (i < prevNatures.length) {
                if (!prevNatures[i].equals(natureId)) {
                    newNatures[j++] = prevNatures[i];
                }
                ++i;
            }
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        }
    }
}

