/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.registry.metadata;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.Encoded;
import org.apache.wink.common.internal.registry.Injectable;
import org.apache.wink.common.internal.registry.InjectableFactory;
import org.apache.wink.common.internal.registry.metadata.ClassMetadata;
import org.apache.wink.common.internal.registry.metadata.ConstructorMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMetadataCollector {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMetadataCollector.class);
    private final ClassMetadata metadata;

    public AbstractMetadataCollector(Class<?> clazz) {
        this.metadata = new ClassMetadata(clazz);
    }

    protected final void parseFields() {
        Class<?> resourceClass;
        logger.trace("parseFields() entry");
        logger.trace("Class is {}", resourceClass);
        List<Injectable> injectableFields = this.metadata.getInjectableFields();
        logger.trace("Injectable fields: {}", injectableFields);
        for (resourceClass = this.metadata.getResourceClass(); resourceClass != Object.class && resourceClass != null; resourceClass = resourceClass.getSuperclass()) {
            for (Field field : resourceClass.getDeclaredFields()) {
                Type fieldType = field.getGenericType();
                Injectable injectable = this.parseAccessibleObject(field, fieldType);
                logger.trace("Field is {} and injectable is {}", (Object)fieldType, (Object)injectable);
                if (injectable == null) continue;
                injectableFields.add(injectable);
            }
        }
        logger.trace("Injectable fields: {}", injectableFields);
        PropertyDescriptor[] propertyDescriptors = this.metadata.getBeanInfo().getPropertyDescriptors();
        if (logger.isTraceEnabled()) {
            logger.trace("Property descriptors are: {}", Arrays.asList(propertyDescriptors));
        }
        if (propertyDescriptors != null) {
            for (PropertyDescriptor pd : propertyDescriptors) {
                Class<?> genericReturnType;
                Injectable injectable;
                Method writeMethod = pd.getWriteMethod();
                if (writeMethod == null) continue;
                if (logger.isTraceEnabled()) {
                    logger.trace("Method under inspection: {}", (Object)writeMethod.getName());
                }
                if ((injectable = this.parseAccessibleObject(writeMethod, genericReturnType = writeMethod.getParameterTypes()[0])) != null) {
                    injectableFields.add(injectable);
                }
                if (!logger.isTraceEnabled()) continue;
                logger.trace("Injectable under inspection: {}", (Object)injectable);
            }
        }
        logger.trace("parseFields() exit");
    }

    protected abstract Injectable parseAccessibleObject(AccessibleObject var1, Type var2);

    protected abstract boolean isConstructorParameterValid(Injectable var1);

    protected final void parseConstructors() {
        logger.trace("parseConstructors() entry");
        ConstructorMetadata constructorMetadata = new ConstructorMetadata();
        ArrayList<Injectable> formalParameters = new ArrayList<Injectable>();
        Class<?> resourceClass = this.metadata.getResourceClass();
        block0: for (Constructor<?> constructor : resourceClass.getDeclaredConstructors()) {
            logger.trace("Constructor is {}", constructor);
            int modifiers = constructor.getModifiers();
            if (!Modifier.isPublic(modifiers)) {
                logger.trace("Constructor is skipped because not public");
                continue;
            }
            constructorMetadata.setEncoded(constructor.getAnnotation(Encoded.class) != null);
            formalParameters.clear();
            Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
            Type[] paramTypes = constructor.getGenericParameterTypes();
            int limit = paramTypes.length;
            for (int pos = 0; pos < limit; ++pos) {
                Injectable fp = InjectableFactory.getInstance().create(paramTypes[pos], parameterAnnotations[pos], constructor, this.getMetadata().isEncoded() || constructorMetadata.isEncoded(), null);
                if (!this.isConstructorParameterValid(fp)) continue block0;
                formalParameters.add(fp);
            }
            if (constructorMetadata.getConstructor() == null || constructorMetadata.getFormalParameters().size() < paramTypes.length) {
                constructorMetadata.setConstructor(constructor);
                constructorMetadata.getFormalParameters().clear();
                constructorMetadata.getFormalParameters().addAll(formalParameters);
                continue;
            }
            if (constructorMetadata.getFormalParameters().size() != paramTypes.length) continue;
        }
        logger.trace("Set constructor to {}", (Object)constructorMetadata);
        this.metadata.setConstructor(constructorMetadata);
        logger.trace("parseConstructors() exit");
    }

    protected void parseEncoded(Class<?> cls) {
        logger.trace("parseEncoded({}) entry", cls);
        Encoded encoded = cls.getAnnotation(Encoded.class);
        if (encoded != null) {
            this.metadata.setEncoded(true);
            logger.trace("parseEncoded() setEncoded to true");
        }
        logger.trace("parseEncoded() exit");
    }

    public ClassMetadata getMetadata() {
        return this.metadata;
    }
}

