/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.EntityTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityTagMatchHeader {
    private List<EntityTag> eTags = new ArrayList<EntityTag>();
    private boolean isWildcard = false;

    public boolean addETag(EntityTag eTag) {
        if (this.isWildcard) {
            return true;
        }
        if (eTag.getValue().equals("*")) {
            this.isWildcard = true;
            this.eTags.clear();
            return true;
        }
        return this.eTags.add(eTag);
    }

    public List<EntityTag> getETags() {
        return Collections.unmodifiableList(this.eTags);
    }

    public boolean isMatch(EntityTag eTag) {
        if (eTag == null) {
            return false;
        }
        if (this.isWildcard) {
            return true;
        }
        String value = eTag.getValue();
        for (EntityTag e : this.eTags) {
            if (!value.equals(e.getValue())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.isWildcard) {
            return "*";
        }
        return this.eTags.toString();
    }
}

