/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.signature;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthException;
import net.oauth.signature.OAuthSignatureMethod;
import net.oauth.signature.pem.PEMReader;
import net.oauth.signature.pem.PKCS1EncodedKeySpec;

public class RSA_SHA1
extends OAuthSignatureMethod {
    public static final String PRIVATE_KEY = "RSA-SHA1.PrivateKey";
    public static final String PUBLIC_KEY = "RSA-SHA1.PublicKey";
    public static final String X509_CERTIFICATE = "RSA-SHA1.X509Certificate";
    private PrivateKey privateKey = null;
    private PublicKey publicKey = null;

    protected void initialize(String name, OAuthAccessor accessor) throws OAuthException {
        super.initialize(name, accessor);
        try {
            Object publicKeyObject;
            Object privateKeyObject = accessor.consumer.getProperty(PRIVATE_KEY);
            if (privateKeyObject != null) {
                this.privateKey = this.loadPrivateKey(privateKeyObject);
            }
            if ((publicKeyObject = accessor.consumer.getProperty(PUBLIC_KEY)) != null) {
                this.publicKey = this.loadPublicKey(publicKeyObject, false);
            } else {
                Object certObject = accessor.consumer.getProperty(X509_CERTIFICATE);
                if (certObject != null) {
                    this.publicKey = this.loadPublicKey(certObject, true);
                }
            }
        }
        catch (GeneralSecurityException e) {
            throw new OAuthException(e);
        }
        catch (IOException e) {
            throw new OAuthException(e);
        }
    }

    private PublicKey getPublicKeyFromDerCert(byte[] certObject) throws GeneralSecurityException {
        CertificateFactory fac = CertificateFactory.getInstance("X509");
        ByteArrayInputStream in = new ByteArrayInputStream(certObject);
        X509Certificate cert = (X509Certificate)fac.generateCertificate(in);
        return cert.getPublicKey();
    }

    private PublicKey getPublicKeyFromDer(byte[] publicKeyObject) throws GeneralSecurityException {
        KeyFactory fac = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(publicKeyObject);
        return fac.generatePublic(pubKeySpec);
    }

    private PublicKey getPublicKeyFromPem(String pem) throws GeneralSecurityException, IOException {
        PublicKey pubKey;
        ByteArrayInputStream stream = new ByteArrayInputStream(pem.getBytes("UTF-8"));
        PEMReader reader = new PEMReader(stream);
        byte[] bytes = reader.getDerBytes();
        if ("-----BEGIN PUBLIC KEY-----".equals(reader.getBeginMarker())) {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(bytes);
            KeyFactory fac = KeyFactory.getInstance("RSA");
            pubKey = fac.generatePublic(keySpec);
        } else if ("-----BEGIN CERTIFICATE-----".equals(reader.getBeginMarker())) {
            pubKey = this.getPublicKeyFromDerCert(bytes);
        } else {
            throw new IOException("Invalid PEM fileL: Unknown marker for  public key or cert " + reader.getBeginMarker());
        }
        return pubKey;
    }

    private PrivateKey getPrivateKeyFromDer(byte[] privateKeyObject) throws GeneralSecurityException {
        KeyFactory fac = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(privateKeyObject);
        return fac.generatePrivate(privKeySpec);
    }

    private PrivateKey getPrivateKeyFromPem(String pem) throws GeneralSecurityException, IOException {
        KeySpec keySpec;
        ByteArrayInputStream stream = new ByteArrayInputStream(pem.getBytes("UTF-8"));
        PEMReader reader = new PEMReader(stream);
        byte[] bytes = reader.getDerBytes();
        if ("-----BEGIN RSA PRIVATE KEY-----".equals(reader.getBeginMarker())) {
            keySpec = new PKCS1EncodedKeySpec(bytes).getKeySpec();
        } else if ("-----BEGIN PRIVATE KEY-----".equals(reader.getBeginMarker())) {
            keySpec = new PKCS8EncodedKeySpec(bytes);
        } else {
            throw new IOException("Invalid PEM file: Unknown marker for private key " + reader.getBeginMarker());
        }
        KeyFactory fac = KeyFactory.getInstance("RSA");
        return fac.generatePrivate(keySpec);
    }

    protected String getSignature(String baseString) throws OAuthException {
        try {
            byte[] signature = this.sign(baseString.getBytes("UTF-8"));
            return RSA_SHA1.base64Encode(signature);
        }
        catch (UnsupportedEncodingException e) {
            throw new OAuthException(e);
        }
        catch (GeneralSecurityException e) {
            throw new OAuthException(e);
        }
    }

    protected boolean isValid(String signature, String baseString) throws OAuthException {
        try {
            return this.verify(RSA_SHA1.decodeBase64(signature), baseString.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new OAuthException(e);
        }
        catch (GeneralSecurityException e) {
            throw new OAuthException(e);
        }
    }

    private byte[] sign(byte[] message) throws GeneralSecurityException {
        if (this.privateKey == null) {
            throw new IllegalStateException("need to set private key with OAuthConsumer.setProperty when generating RSA-SHA1 signatures.");
        }
        Signature signer = Signature.getInstance("SHA1withRSA");
        signer.initSign(this.privateKey);
        signer.update(message);
        return signer.sign();
    }

    private boolean verify(byte[] signature, byte[] message) throws GeneralSecurityException {
        if (this.publicKey == null) {
            throw new IllegalStateException("need to set public key with  OAuthConsumer.setProperty when verifying RSA-SHA1 signatures.");
        }
        Signature verifier = Signature.getInstance("SHA1withRSA");
        verifier.initVerify(this.publicKey);
        verifier.update(message);
        return verifier.verify(signature);
    }

    private PrivateKey loadPrivateKey(Object privateKeyObject) throws IOException, GeneralSecurityException {
        PrivateKey privateKey;
        if (privateKeyObject instanceof PrivateKey) {
            privateKey = (PrivateKey)privateKeyObject;
        } else if (privateKeyObject instanceof String) {
            try {
                privateKey = this.getPrivateKeyFromPem((String)privateKeyObject);
            }
            catch (IOException e) {
                privateKey = this.getPrivateKeyFromDer(RSA_SHA1.decodeBase64((String)privateKeyObject));
            }
        } else if (privateKeyObject instanceof byte[]) {
            privateKey = this.getPrivateKeyFromDer((byte[])privateKeyObject);
        } else {
            throw new IllegalArgumentException("Private key set through RSA_SHA1.PRIVATE_KEY must be of type PrivateKey, String or byte[] and not " + privateKeyObject.getClass().getName());
        }
        return privateKey;
    }

    private PublicKey loadPublicKey(Object publicKeyObject, boolean isCert) throws IOException, GeneralSecurityException {
        PublicKey publicKey;
        if (publicKeyObject instanceof PublicKey) {
            publicKey = (PublicKey)publicKeyObject;
        } else if (publicKeyObject instanceof X509Certificate) {
            publicKey = ((X509Certificate)publicKeyObject).getPublicKey();
        } else if (publicKeyObject instanceof String) {
            try {
                publicKey = this.getPublicKeyFromPem((String)publicKeyObject);
            }
            catch (IOException e) {
                if (isCert) {
                    throw e;
                }
                publicKey = this.getPublicKeyFromDer(RSA_SHA1.decodeBase64((String)publicKeyObject));
            }
        } else if (publicKeyObject instanceof byte[]) {
            publicKey = isCert ? this.getPublicKeyFromDerCert((byte[])publicKeyObject) : this.getPublicKeyFromDer((byte[])publicKeyObject);
        } else {
            String source = isCert ? "RSA_SHA1.X509_CERTIFICATE" : "RSA_SHA1.PUBLIC_KEY";
            throw new IllegalArgumentException("Public key or certificate set through " + source + " must be of " + "type PublicKey, String or byte[], and not " + publicKeyObject.getClass().getName());
        }
        return publicKey;
    }
}

