/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.shared.uuid;

import com.hp.hpl.jena.shared.uuid.Bits;
import com.hp.hpl.jena.shared.uuid.JenaUUID;
import com.hp.hpl.jena.shared.uuid.LibUUID;
import com.hp.hpl.jena.shared.uuid.UUID_V4_Gen;
import java.security.SecureRandom;
import java.util.Random;

public class UUID_V4
extends JenaUUID {
    public static final int version = 4;
    public static final int variant = 2;
    static Random random = null;
    long bitsMostSignificant = 0L;
    long bitsLeastSignificant = 0L;
    static boolean initialized = false;

    UUID_V4(long mostSigBits, long leastSigBits) {
        if (!this.check(mostSigBits, leastSigBits)) {
            throw new IllegalArgumentException("Funny bits");
        }
        this.bitsMostSignificant = mostSigBits;
        this.bitsLeastSignificant = leastSigBits;
    }

    public long getMostSignificantBits() {
        return this.bitsMostSignificant;
    }

    public long getLeastSignificantBits() {
        return this.bitsLeastSignificant;
    }

    private boolean check(long mostSigBits, long leastSigBits) {
        int _variant = this._getVariant(mostSigBits, leastSigBits);
        int _version = this._getVersion(mostSigBits, leastSigBits);
        if (_variant != 2) {
            return false;
        }
        return _version == 4;
    }

    public String toString() {
        return UUID_V4_Gen.unparse(this);
    }

    public int hashCode() {
        return (int)Bits.unpack(this.bitsMostSignificant, 32, 64);
    }

    public boolean equals(Object other) {
        if (!(other instanceof UUID_V4)) {
            return false;
        }
        UUID_V4 u = (UUID_V4)other;
        return this.bitsMostSignificant == u.bitsMostSignificant && this.bitsLeastSignificant == u.bitsLeastSignificant;
    }

    public static void init() {
        if (!initialized) {
            UUID_V4.reset();
            initialized = true;
        }
    }

    public static void uninit() {
        initialized = false;
    }

    public static void reset() {
        random = new SecureRandom();
        byte[] seed = LibUUID.makeSeed();
        if (random == null) {
            random = new Random();
            long l = 0L;
            for (int i = 0; i < 8; ++i) {
                l = l << 8 | (long)(seed[i] & 0xFF);
            }
            random = new Random();
            random.setSeed(l);
        }
    }

    public int getVersion() {
        return this._getVersion(this.bitsMostSignificant, this.bitsLeastSignificant);
    }

    public int getVariant() {
        return this._getVariant(this.bitsMostSignificant, this.bitsLeastSignificant);
    }
}

