/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.core.query.impl;

import java.lang.reflect.Method;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.lyo.core.query.LangedStringValue;
import org.eclipse.lyo.core.query.Value;
import org.eclipse.lyo.core.query.impl.ValueInvocationHandler;

class LangedStringValueInvocationHandler
extends ValueInvocationHandler {
    private String value = null;
    private String langTag = null;

    public LangedStringValueInvocationHandler(CommonTree tree) {
        super(tree, Value.Type.LANGED_STRING);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        boolean isValue = methodName.equals("value");
        if (!(isValue || methodName.equals("langTag") || methodName.equals("toString"))) {
            return super.invoke(proxy, method, args);
        }
        if (isValue) {
            if (this.value == null) {
                String rawValue = ((CommonTree)this.tree.getChild(0)).getText();
                this.value = rawValue.substring(1, rawValue.length() - 1);
            }
            return this.value;
        }
        if (this.langTag == null) {
            this.langTag = ((CommonTree)this.tree.getChild(1)).getText().substring(1);
        }
        if (methodName.equals("langTag")) {
            return this.langTag;
        }
        return '\"' + ((LangedStringValue)proxy).value() + "\"@" + ((LangedStringValue)proxy).langTag();
    }
}

