/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.client.oslc;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.core.Application;
import net.oauth.OAuthException;
import net.oauth.client.httpclient4.HttpClientPool;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.wink.client.ClientConfig;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.Resource;
import org.apache.wink.client.RestClient;
import org.apache.wink.client.httpclient.ApacheHttpClientConfig;
import org.eclipse.lyo.client.exception.ResourceNotFoundException;
import org.eclipse.lyo.client.oslc.resources.OslcQuery;
import org.eclipse.lyo.oslc4j.core.model.CreationFactory;
import org.eclipse.lyo.oslc4j.core.model.QueryCapability;
import org.eclipse.lyo.oslc4j.core.model.Service;
import org.eclipse.lyo.oslc4j.core.model.ServiceProvider;
import org.eclipse.lyo.oslc4j.core.model.ServiceProviderCatalog;
import org.eclipse.lyo.oslc4j.provider.jena.JenaProvidersRegistry;
import org.eclipse.lyo.oslc4j.provider.json4j.Json4JProvidersRegistry;

public class OslcClient {
    protected DefaultHttpClient httpClient = new DefaultHttpClient();
    private HttpClientPool clientPool;
    private ClientConfig clientConfig;
    private static final String[] SECURE_SOCKET_PROTOCOL = new String[]{"TLS", "SSL", "SSL_TLS"};

    public OslcClient() {
        this(null, null);
    }

    public OslcClient(TrustManager[] trustManagers, X509HostnameVerifier hostnameVerifier) {
        this.httpClient.setRedirectStrategy(new RedirectStrategy(){

            public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) {
                return null;
            }

            public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) {
                return false;
            }
        });
        this.setupSSLSupport(trustManagers, hostnameVerifier);
        this.clientPool = new OAuthHttpPool();
        this.clientConfig = new ApacheHttpClientConfig((HttpClient)this.httpClient);
        Application app = new Application(){

            public Set<Class<?>> getClasses() {
                HashSet classes = new HashSet();
                classes.addAll(JenaProvidersRegistry.getProviders());
                classes.addAll(Json4JProvidersRegistry.getProviders());
                return classes;
            }
        };
        this.clientConfig = this.clientConfig.applications(new Application[]{app});
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    protected HttpClientPool getClientPool() {
        return this.clientPool;
    }

    protected ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public ClientResponse getResource(String url, String mediaType) throws IOException, OAuthException, URISyntaxException {
        ClientResponse response = null;
        RestClient restClient = new RestClient(this.clientConfig);
        boolean redirect = false;
        do {
            if ((response = restClient.resource(url).accept(new String[]{mediaType}).header("OSLC-Core-Version", new String[]{"2.0"}).get()).getStatusCode() == 301 || response.getStatusCode() == 302) {
                url = (String)response.getHeaders().getFirst((Object)"Location");
                response.consumeContent();
                redirect = true;
                continue;
            }
            redirect = false;
        } while (redirect);
        return response;
    }

    public ClientResponse deleteResource(String url) throws IOException, OAuthException, URISyntaxException {
        ClientResponse response = null;
        RestClient restClient = new RestClient(this.clientConfig);
        boolean redirect = false;
        do {
            if ((response = restClient.resource(url).delete()).getStatusCode() == 301 || response.getStatusCode() == 302) {
                url = (String)response.getHeaders().getFirst((Object)"Location");
                response.consumeContent();
                redirect = true;
                continue;
            }
            redirect = false;
        } while (redirect);
        return response;
    }

    public ClientResponse createResource(String url, Object artifact, String mediaType) throws IOException, OAuthException, URISyntaxException {
        return this.createResource(url, artifact, mediaType, "*/*");
    }

    public ClientResponse createResource(String url, Object artifact, String mediaType, String acceptType) throws IOException, OAuthException, URISyntaxException {
        ClientResponse response = null;
        RestClient restClient = new RestClient(this.clientConfig);
        boolean redirect = false;
        do {
            if ((response = restClient.resource(url).contentType(mediaType).accept(new String[]{acceptType}).header("OSLC-Core-Version", new String[]{"2.0"}).post(artifact)).getStatusCode() == 301 || response.getStatusCode() == 302) {
                url = (String)response.getHeaders().getFirst((Object)"Location");
                response.consumeContent();
                redirect = true;
                continue;
            }
            redirect = false;
        } while (redirect);
        return response;
    }

    public ClientResponse updateResource(String url, Object artifact, String mediaType) {
        return this.updateResource(url, artifact, mediaType, "*/*");
    }

    public ClientResponse updateResource(String url, Object artifact, String mediaType, String acceptType) {
        ClientResponse response = null;
        RestClient restClient = new RestClient(this.clientConfig);
        boolean redirect = false;
        do {
            if ((response = restClient.resource(url).contentType(mediaType).accept(new String[]{acceptType}).header("OSLC-Core-Version", new String[]{"2.0"}).put(artifact)).getStatusCode() == 301 || response.getStatusCode() == 302) {
                url = (String)response.getHeaders().getFirst((Object)"Location");
                response.consumeContent();
                redirect = true;
                continue;
            }
            redirect = false;
        } while (redirect);
        return response;
    }

    public ClientResponse updateResource(String url, Object artifact, String mediaType, String acceptType, String ifMatch) throws IOException, OAuthException, URISyntaxException {
        ClientResponse response = null;
        RestClient restClient = new RestClient(this.clientConfig);
        boolean redirect = false;
        do {
            if ((response = restClient.resource(url).contentType(mediaType).accept(new String[]{acceptType}).header("OSLC-Core-Version", new String[]{"2.0"}).header("If-Match", new String[]{ifMatch}).put(artifact)).getStatusCode() == 301 || response.getStatusCode() == 302) {
                url = (String)response.getHeaders().getFirst((Object)"Location");
                response.consumeContent();
                redirect = true;
                continue;
            }
            redirect = false;
        } while (redirect);
        return response;
    }

    public Resource getQueryResource(OslcQuery query) {
        RestClient restClient = new RestClient(this.clientConfig);
        Resource resource = restClient.resource(query.getCapabilityUrl());
        return resource;
    }

    public String lookupServiceProviderUrl(String catalogUrl, String serviceProviderTitle) throws IOException, OAuthException, URISyntaxException, ResourceNotFoundException {
        String retval = null;
        ClientResponse response = this.getResource(catalogUrl, "application/rdf+xml");
        ServiceProviderCatalog catalog = (ServiceProviderCatalog)response.getEntity(ServiceProviderCatalog.class);
        if (catalog != null) {
            for (ServiceProvider sp : catalog.getServiceProviders()) {
                if (sp.getTitle() == null || !sp.getTitle().equalsIgnoreCase(serviceProviderTitle)) continue;
                retval = sp.getAbout().toString();
                break;
            }
        }
        if (retval == null) {
            throw new ResourceNotFoundException(catalogUrl, serviceProviderTitle);
        }
        return retval;
    }

    public String lookupQueryCapability(String serviceProviderUrl, String oslcDomain, String oslcResourceType) throws IOException, OAuthException, URISyntaxException, ResourceNotFoundException {
        QueryCapability defaultQueryCapability = null;
        QueryCapability firstQueryCapability = null;
        ClientResponse response = this.getResource(serviceProviderUrl, "application/rdf+xml");
        ServiceProvider serviceProvider = (ServiceProvider)response.getEntity(ServiceProvider.class);
        if (serviceProvider != null) {
            for (Service service : serviceProvider.getServices()) {
                QueryCapability[] queryCapabilities;
                URI domain = service.getDomain();
                if (domain == null || !domain.toString().equals(oslcDomain) || (queryCapabilities = service.getQueryCapabilities()) == null || queryCapabilities.length <= 0) continue;
                firstQueryCapability = queryCapabilities[0];
                for (QueryCapability queryCapability : service.getQueryCapabilities()) {
                    for (URI resourceType : queryCapability.getResourceTypes()) {
                        if (resourceType.toString() == null || !resourceType.toString().equals(oslcResourceType)) continue;
                        return queryCapability.getQueryBase().toString();
                    }
                    for (URI usage : queryCapability.getUsages()) {
                        if (usage.toString() == null || !usage.toString().equals("http://open-services.net/ns/core#default")) continue;
                        defaultQueryCapability = queryCapability;
                    }
                }
            }
        }
        if (defaultQueryCapability != null) {
            return defaultQueryCapability.getQueryBase().toString();
        }
        if (firstQueryCapability != null && firstQueryCapability.getResourceTypes().length == 0) {
            return firstQueryCapability.getQueryBase().toString();
        }
        throw new ResourceNotFoundException(serviceProviderUrl, "QueryCapability");
    }

    public String lookupCreationFactory(String serviceProviderUrl, String oslcDomain, String oslcResourceType) throws IOException, OAuthException, URISyntaxException, ResourceNotFoundException {
        CreationFactory defaultCreationFactory = null;
        CreationFactory firstCreationFactory = null;
        ClientResponse response = this.getResource(serviceProviderUrl, "application/rdf+xml");
        ServiceProvider serviceProvider = (ServiceProvider)response.getEntity(ServiceProvider.class);
        if (serviceProvider != null) {
            for (Service service : serviceProvider.getServices()) {
                CreationFactory[] creationFactories;
                URI domain = service.getDomain();
                if (domain == null || !domain.toString().equals(oslcDomain) || (creationFactories = service.getCreationFactories()) == null || creationFactories.length <= 0) continue;
                firstCreationFactory = creationFactories[0];
                for (CreationFactory creationFactory : creationFactories) {
                    for (URI resourceType : creationFactory.getResourceTypes()) {
                        if (resourceType.toString() == null || !resourceType.toString().equals(oslcResourceType)) continue;
                        return creationFactory.getCreation().toString();
                    }
                    for (URI usage : creationFactory.getUsages()) {
                        if (usage.toString() == null || !usage.toString().equals("http://open-services.net/ns/core#default")) continue;
                        defaultCreationFactory = creationFactory;
                    }
                }
            }
        }
        if (defaultCreationFactory != null) {
            return defaultCreationFactory.getCreation().toString();
        }
        if (firstCreationFactory != null && firstCreationFactory.getResourceTypes().length == 0) {
            return firstCreationFactory.getCreation().toString();
        }
        throw new ResourceNotFoundException(serviceProviderUrl, "CreationFactory");
    }

    private SSLContext findInstalledSecurityContext() throws NoSuchAlgorithmException {
        for (String aSecuredProtocol : SECURE_SOCKET_PROTOCOL) {
            try {
                return SSLContext.getInstance(aSecuredProtocol);
            }
            catch (NoSuchAlgorithmException e) {
            }
        }
        throw new NoSuchAlgorithmException("No suitable secured socket provider is installed");
    }

    private void setupSSLSupport(TrustManager[] trustManagers, X509HostnameVerifier hostnameVerifier) {
        ClientConnectionManager connManager = this.httpClient.getConnectionManager();
        SchemeRegistry schemeRegistry = connManager.getSchemeRegistry();
        schemeRegistry.unregister("https");
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        try {
            SSLContext sc = this.findInstalledSecurityContext();
            if (trustManagers == null) {
                trustManagers = trustAllCerts;
            }
            if (hostnameVerifier == null) {
                hostnameVerifier = SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
            }
            sc.init(null, trustManagers, new SecureRandom());
            SSLSocketFactory sf = new SSLSocketFactory(sc, hostnameVerifier);
            Scheme https = new Scheme("https", 443, (SchemeSocketFactory)sf);
            schemeRegistry.register(https);
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (KeyManagementException e) {
            // empty catch block
        }
    }

    protected class OAuthHttpPool
    implements HttpClientPool {
        protected OAuthHttpPool() {
        }

        public HttpClient getHttpClient(URL url) {
            return OslcClient.this.httpClient;
        }
    }
}

