/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.server.oauth.core.token;

import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import org.eclipse.lyo.server.oauth.core.OAuthRequest;
import org.eclipse.lyo.server.oauth.core.token.LRUCache;
import org.eclipse.lyo.server.oauth.core.token.TokenStrategy;

public class SimpleTokenStrategy
implements TokenStrategy {
    private static final int REQUEST_TOKEN_MAX_ENTIRES = 500;
    private static final int ACCESS_TOKEN_MAX_ENTRIES = 5000;
    private Map<String, RequestTokenData> requestTokens;
    private Map<String, String> accessTokens;
    private Map<String, String> tokenSecrets;

    public SimpleTokenStrategy() {
        this(500, 5000);
    }

    public SimpleTokenStrategy(int requestTokenMaxCount, int accessTokenMaxCount) {
        this.requestTokens = new LRUCache<String, RequestTokenData>(requestTokenMaxCount);
        this.accessTokens = new LRUCache<String, String>(accessTokenMaxCount);
        this.tokenSecrets = new LRUCache<String, String>(requestTokenMaxCount + accessTokenMaxCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateRequestToken(OAuthRequest oAuthRequest) throws IOException {
        OAuthAccessor accessor = oAuthRequest.getAccessor();
        accessor.requestToken = this.generateTokenString();
        accessor.tokenSecret = this.generateTokenString();
        String callback = oAuthRequest.getMessage().getParameter("oauth_callback");
        Map<String, Object> map = this.requestTokens;
        synchronized (map) {
            this.requestTokens.put(accessor.requestToken, new RequestTokenData(accessor.consumer.consumerKey, callback));
        }
        map = this.tokenSecrets;
        synchronized (map) {
            this.tokenSecrets.put(accessor.requestToken, accessor.tokenSecret);
        }
    }

    @Override
    public String validateRequestToken(HttpServletRequest httpRequest, OAuthMessage message) throws OAuthException, IOException {
        return this.getRequestTokenData(message.getToken()).getConsumerKey();
    }

    @Override
    public String getCallback(HttpServletRequest httpRequest, String requestToken) throws OAuthProblemException {
        return this.getRequestTokenData(requestToken).getCallback();
    }

    @Override
    public void markRequestTokenAuthorized(HttpServletRequest httpRequest, String requestToken) throws OAuthProblemException {
        this.getRequestTokenData(requestToken).setAuthorized(true);
    }

    @Override
    public boolean isRequestTokenAuthorized(HttpServletRequest httpRequest, String requestToken) throws OAuthProblemException {
        return this.getRequestTokenData(requestToken).isAuthorized();
    }

    @Override
    public String generateVerificationCode(HttpServletRequest httpRequest, String requestToken) throws OAuthProblemException {
        String verificationCode = this.generateTokenString();
        this.getRequestTokenData(requestToken).setVerificationCode(verificationCode);
        return verificationCode;
    }

    @Override
    public void validateVerificationCode(OAuthRequest oAuthRequest) throws OAuthException, IOException {
        String verificationCode = oAuthRequest.getMessage().getParameter("oauth_verifier");
        if (verificationCode == null) {
            throw new OAuthProblemException("oauth_parameters_absent");
        }
        RequestTokenData tokenData = this.getRequestTokenData(oAuthRequest);
        if (!verificationCode.equals(tokenData.getVerificationCode())) {
            throw new OAuthProblemException("oauth_parameters_rejected");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateAccessToken(OAuthRequest oAuthRequest) throws OAuthProblemException, IOException {
        OAuthAccessor accessor = oAuthRequest.getAccessor();
        String requestToken = oAuthRequest.getMessage().getToken();
        Map<String, Object> map = this.requestTokens;
        synchronized (map) {
            if (!this.isRequestTokenAuthorized(oAuthRequest.getHttpRequest(), requestToken)) {
                throw new OAuthProblemException("additional_authorization_required");
            }
            this.requestTokens.remove(requestToken);
        }
        accessor.accessToken = this.generateTokenString();
        map = this.accessTokens;
        synchronized (map) {
            this.accessTokens.put(accessor.accessToken, accessor.consumer.consumerKey);
        }
        accessor.tokenSecret = this.generateTokenString();
        map = this.tokenSecrets;
        synchronized (map) {
            this.tokenSecrets.remove(requestToken);
            this.tokenSecrets.put(accessor.accessToken, accessor.tokenSecret);
        }
        accessor.requestToken = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateAccessToken(OAuthRequest oAuthRequest) throws OAuthException, IOException {
        Map<String, String> map = this.accessTokens;
        synchronized (map) {
            String actualValue = this.accessTokens.get(oAuthRequest.getMessage().getToken());
            if (!oAuthRequest.getConsumer().consumerKey.equals(actualValue)) {
                throw new OAuthProblemException("token_rejected");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTokenSecret(HttpServletRequest httpRequest, String token) throws OAuthProblemException {
        Map<String, String> map = this.tokenSecrets;
        synchronized (map) {
            String tokenSecret = this.tokenSecrets.get(token);
            if (tokenSecret == null) {
                throw new OAuthProblemException("token_rejected");
            }
            return tokenSecret;
        }
    }

    protected String generateTokenString() {
        return UUID.randomUUID().toString();
    }

    protected RequestTokenData getRequestTokenData(OAuthRequest oAuthRequest) throws OAuthProblemException, IOException {
        return this.getRequestTokenData(oAuthRequest.getMessage().getToken());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RequestTokenData getRequestTokenData(String requestToken) throws OAuthProblemException {
        Map<String, RequestTokenData> map = this.requestTokens;
        synchronized (map) {
            RequestTokenData tokenData = this.requestTokens.get(requestToken);
            if (tokenData == null) {
                throw new OAuthProblemException("token_rejected");
            }
            return tokenData;
        }
    }

    protected class RequestTokenData {
        private String consumerKey;
        private boolean authorized;
        private String callback;
        private String verificationCode;

        public RequestTokenData(String consumerKey) {
            this.consumerKey = consumerKey;
            this.authorized = false;
            this.callback = null;
        }

        public RequestTokenData(String consumerKey, String callback) {
            this.consumerKey = consumerKey;
            this.authorized = false;
            this.callback = callback;
        }

        public String getConsumerKey() {
            return this.consumerKey;
        }

        public void setConsumerKey(String consumerKey) {
            this.consumerKey = consumerKey;
        }

        public boolean isAuthorized() {
            return this.authorized;
        }

        public void setAuthorized(boolean authorized) {
            this.authorized = authorized;
        }

        public String getCallback() {
            return this.callback;
        }

        public void setCallback(String callback) {
            this.callback = callback;
        }

        public String getVerificationCode() {
            return this.verificationCode;
        }

        public void setVerificationCode(String verificationCode) {
            this.verificationCode = verificationCode;
        }
    }
}

