/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.server.oauth.core;

import net.oauth.OAuthProblemException;
import net.oauth.OAuthValidator;
import net.oauth.SimpleOAuthValidator;
import org.eclipse.lyo.server.oauth.core.Application;
import org.eclipse.lyo.server.oauth.core.consumer.ConsumerStore;
import org.eclipse.lyo.server.oauth.core.consumer.ConsumerStoreException;
import org.eclipse.lyo.server.oauth.core.token.SimpleTokenStrategy;
import org.eclipse.lyo.server.oauth.core.token.TokenStrategy;

public class OAuthConfiguration {
    private OAuthValidator validator = new SimpleOAuthValidator();
    private TokenStrategy tokenStrategy = new SimpleTokenStrategy();
    private ConsumerStore consumerStore = null;
    private Application application = null;
    private boolean v1_0Allowed = true;
    private static final OAuthConfiguration instance = new OAuthConfiguration();

    public static OAuthConfiguration getInstance() {
        return instance;
    }

    private OAuthConfiguration() {
    }

    public OAuthValidator getValidator() {
        return this.validator;
    }

    public void setValidator(OAuthValidator validator) {
        this.validator = validator;
    }

    public TokenStrategy getTokenStrategy() {
        return this.tokenStrategy;
    }

    public void setTokenStrategy(TokenStrategy tokenStrategy) {
        this.tokenStrategy = tokenStrategy;
    }

    public ConsumerStore getConsumerStore() {
        return this.consumerStore;
    }

    public void setConsumerStore(ConsumerStore consumerStore) throws ConsumerStoreException {
        this.consumerStore = consumerStore;
    }

    public Application getApplication() throws OAuthProblemException {
        if (this.application == null) {
            OAuthProblemException e = new OAuthProblemException();
            e.setParameter("HTTP status", (Object)503);
            throw e;
        }
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public boolean isV1_0Allowed() {
        return this.v1_0Allowed;
    }

    public void setV1_0Allowed(boolean allowed) {
        this.v1_0Allowed = allowed;
    }
}

