/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.server.oauth.consumerstore;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PropertyNotFoundException;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.eclipse.lyo.server.oauth.core.consumer.AbstractConsumerStore;
import org.eclipse.lyo.server.oauth.core.consumer.ConsumerStoreException;
import org.eclipse.lyo.server.oauth.core.consumer.LyoOAuthConsumer;

public class FileSystemConsumerStore
extends AbstractConsumerStore {
    protected static final String LYO_OAUTH_NAMESPACE = "http://eclipse.org/lyo/server/oauth#";
    protected static final String CONSUMER_RESOURCE = "http://eclipse.org/lyo/server/oauth#Consumer";
    protected static final String CALLBACK_URL = "http://eclipse.org/lyo/server/oauth#callback";
    protected static final String CONSUMER_NAME = "http://eclipse.org/lyo/server/oauth#consumerName";
    protected static final String CONSUMER_KEY = "http://eclipse.org/lyo/server/oauth#consumerKey";
    protected static final String CONSUMER_SECRET = "http://eclipse.org/lyo/server/oauth#consumerSecret";
    protected static final String PROVISIONAL = "http://eclipse.org/lyo/server/oauth#provisional";
    protected static final String TRUSTED = "http://eclipse.org/lyo/server/oauth#trusted";
    private Logger logger = Logger.getLogger(FileSystemConsumerStore.class);
    private Model model;
    private String oauthStore;

    public FileSystemConsumerStore(String oauthStoreRoot) throws SQLException, ConsumerStoreException, ClassNotFoundException {
        this.oauthStore = oauthStoreRoot;
        this.createModel();
        this.loadConsumers();
    }

    public FileSystemConsumerStore(Model model, String oauthStoreRoot) throws ConsumerStoreException {
        this.oauthStore = oauthStoreRoot;
        this.model = model;
        this.loadConsumers();
    }

    protected void createModel() {
        try {
            this.model = FileManager.get().loadModel(this.oauthStore);
        }
        catch (Exception e) {
            this.model = ModelFactory.createDefaultModel();
        }
    }

    protected void writeModel() throws FileNotFoundException {
        Model writeModel = ModelFactory.createDefaultModel();
        writeModel.add(this.model);
        FileOutputStream os = new FileOutputStream(this.oauthStore);
        writeModel.write((OutputStream)os, "RDF/XML-ABBREV");
    }

    protected synchronized void loadConsumers() throws ConsumerStoreException {
        ResIterator i = this.model.listResourcesWithProperty(RDF.type, (RDFNode)this.model.createResource(CONSUMER_RESOURCE));
        while (i.hasNext()) {
            Resource consumerResource = (Resource)i.next();
            try {
                this.add(this.fromResource(consumerResource));
            }
            catch (PropertyNotFoundException e) {
                this.logger.error((Object)("Could not load consumer " + consumerResource.getProperty(this.model.createProperty(CONSUMER_NAME)) + " (" + consumerResource.getProperty(this.model.createProperty(CONSUMER_KEY)) + ")"), (Throwable)e);
            }
            catch (UnsupportedEncodingException ue) {
                throw new ConsumerStoreException((Throwable)ue);
            }
            catch (JenaException e) {
                throw new ConsumerStoreException((Throwable)e);
            }
        }
    }

    public synchronized LyoOAuthConsumer addConsumer(LyoOAuthConsumer consumer) throws ConsumerStoreException {
        if (this.model == null) {
            throw new ConsumerStoreException("Consumer store not initialized.");
        }
        try {
            this.removeProperties(consumer);
            this.toResource(consumer);
            LyoOAuthConsumer retConsumer = this.add(consumer);
            this.writeModel();
            return retConsumer;
        }
        catch (UnsupportedEncodingException ue) {
            throw new ConsumerStoreException((Throwable)ue);
        }
        catch (FileNotFoundException fe) {
            throw new ConsumerStoreException((Throwable)fe);
        }
    }

    public synchronized LyoOAuthConsumer removeConsumer(String consumerKey) throws ConsumerStoreException {
        if (this.model == null) {
            throw new ConsumerStoreException("Consumer store not initialized.");
        }
        try {
            this.removeProperties(consumerKey);
            LyoOAuthConsumer retConsumer = this.remove(consumerKey);
            this.writeModel();
            return retConsumer;
        }
        catch (FileNotFoundException fe) {
            throw new ConsumerStoreException((Throwable)fe);
        }
    }

    public LyoOAuthConsumer updateConsumer(LyoOAuthConsumer consumer) throws ConsumerStoreException {
        return this.addConsumer(consumer);
    }

    public void closeConsumerStore() {
        try {
            this.writeModel();
        }
        catch (Exception e) {
            this.logger.error((Object)"Error finalizing model to disk");
        }
        this.model.close();
    }

    protected void removeProperties(String consumerKey) {
        ResIterator i = this.model.listResourcesWithProperty(this.model.createProperty(CONSUMER_KEY), (RDFNode)this.model.createLiteral(consumerKey));
        while (i.hasNext()) {
            ((Resource)i.next()).removeProperties();
        }
    }

    protected void removeProperties(LyoOAuthConsumer consumer) {
        this.removeProperties(consumer.consumerKey);
    }

    protected Resource toResource(LyoOAuthConsumer consumer) throws UnsupportedEncodingException {
        Resource resource = this.model.createResource();
        resource.addProperty(RDF.type, (RDFNode)this.model.createResource(CONSUMER_RESOURCE));
        resource.addProperty(this.model.createProperty(CONSUMER_NAME), consumer.getName());
        resource.addProperty(this.model.createProperty(CONSUMER_KEY), consumer.consumerKey);
        String encodedSecret = new String(Base64.encodeBase64((byte[])consumer.consumerSecret.getBytes("UTF8")), "UTF8");
        resource.addProperty(this.model.createProperty(CONSUMER_SECRET), encodedSecret);
        resource.addProperty(this.model.createProperty(PROVISIONAL), consumer.isProvisional() ? "true" : "false");
        resource.addProperty(this.model.createProperty(TRUSTED), consumer.isTrusted() ? "true" : "false");
        return resource;
    }

    protected LyoOAuthConsumer fromResource(Resource resource) throws UnsupportedEncodingException {
        String key = resource.getRequiredProperty(this.model.createProperty(CONSUMER_KEY)).getString();
        String encodedSecret = resource.getRequiredProperty(this.model.createProperty(CONSUMER_SECRET)).getString();
        String secret = new String(Base64.decodeBase64((byte[])encodedSecret.getBytes("UTF8")), "UTF8");
        LyoOAuthConsumer consumer = new LyoOAuthConsumer(key, secret);
        consumer.setName(resource.getRequiredProperty(this.model.createProperty(CONSUMER_NAME)).getString());
        String provisional = resource.getProperty(this.model.createProperty(PROVISIONAL)).getString();
        consumer.setProvisional("true".equals(provisional));
        String trusted = resource.getProperty(this.model.createProperty(TRUSTED)).getString();
        consumer.setTrusted("true".equals(trusted));
        return consumer;
    }
}

