/*
 * Decompiled with CFR 0.152.
 */
package tdb.cmdline;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.tdb.store.GraphTDB;
import tdb.cmdline.CmdTDB;

public abstract class CmdTDBGraph
extends CmdTDB {
    private static final ArgDecl argNamedGraph = new ArgDecl(true, "graph");
    protected String graphName = null;

    protected CmdTDBGraph(String[] argv) {
        super(argv);
        super.add(argNamedGraph, "--graph=IRI", "Act on a named graph");
    }

    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
        if (this.contains(argNamedGraph)) {
            this.graphName = this.getValue(argNamedGraph);
        }
    }

    protected Model getModel() {
        Dataset ds = this.tdbDatasetAssembler.getDataset();
        if (this.graphName != null) {
            Model m = ds.getNamedModel(this.graphName);
            if (m == null) {
                throw new CmdException("No such named graph (is this a TDB dataset?)");
            }
            return m;
        }
        return ds.getDefaultModel();
    }

    protected GraphTDB getGraph() {
        if (this.graphName != null) {
            return (GraphTDB)this.tdbDatasetAssembler.getDataset().getNamedModel(this.graphName).getGraph();
        }
        return (GraphTDB)this.tdbDatasetAssembler.getDataset().getDefaultModel().getGraph();
    }

    protected String getCommandName() {
        return Utils.className((Object)((Object)this));
    }
}

