/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.store.bulkloader3;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.jena.tdb.store.bulkloader3.DataStreamFactory;
import org.openjena.atlas.AtlasException;
import org.openjena.atlas.lib.Closeable;
import org.openjena.atlas.lib.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PairInputStream
implements Iterator<Pair<byte[], byte[]>>,
Closeable {
    private DataInputStream in;
    private Pair<byte[], byte[]> slot = null;

    public PairInputStream(InputStream in) {
        this.in = DataStreamFactory.createDataInputStream(in);
        this.slot = this.readNext();
    }

    @Override
    public boolean hasNext() {
        return this.slot != null;
    }

    @Override
    public Pair<byte[], byte[]> next() {
        Pair<byte[], byte[]> result = this.slot;
        this.slot = this.readNext();
        return result;
    }

    private Pair<byte[], byte[]> readNext() {
        try {
            byte[] left = new byte[this.in.readInt()];
            this.in.readFully(left);
            byte[] right = new byte[this.in.readInt()];
            this.in.readFully(right);
            return new Pair((Object)left, (Object)right);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public void remove() {
        throw new AtlasException("Method not implemented.");
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            new AtlasException((Throwable)e);
        }
    }
}

