/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.store.bulkloader3;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.AnonId;
import java.util.HashMap;
import java.util.Map;
import org.openjena.riot.lang.LabelToNode;
import org.openjena.riot.system.MapWithScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomLabelToNode
extends LabelToNode {
    private static final Logger log = LoggerFactory.getLogger(LabelToNode.class);

    public CustomLabelToNode(String runId, String filename) {
        super((MapWithScope.ScopePolicy)new SingleScopePolicy(), (MapWithScope.Allocator)new LabelAllocator(runId, filename));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LabelAllocator
    implements MapWithScope.Allocator<String, Node> {
        private String runId;
        private String filename;

        public LabelAllocator(String runId, String filename) {
            this.runId = runId;
            this.filename = filename;
            log.debug("LabelAllocator({}, {})", (Object)runId, (Object)filename);
        }

        public Node create(String label) {
            String strLabel = "tdbloader3_" + this.runId.hashCode() + "_" + this.filename.hashCode() + "_" + label;
            log.debug("create({}) = {}", (Object)label, (Object)strLabel);
            return Node.createAnon((AnonId)new AnonId(strLabel));
        }

        public void reset() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SingleScopePolicy
    implements MapWithScope.ScopePolicy<String, Node, Node> {
        private Map<String, Node> map = new HashMap<String, Node>();

        private SingleScopePolicy() {
        }

        public Map<String, Node> getScope(Node scope) {
            return this.map;
        }

        public void clear() {
            this.map.clear();
        }
    }
}

