/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.setup;

import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockMgrFactory;
import com.hp.hpl.jena.tdb.base.file.FileFactory;
import com.hp.hpl.jena.tdb.base.file.FileSet;
import com.hp.hpl.jena.tdb.base.objectfile.ObjectFile;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.Index;
import com.hp.hpl.jena.tdb.index.RangeIndex;
import com.hp.hpl.jena.tdb.index.TupleIndex;
import com.hp.hpl.jena.tdb.index.TupleIndexRecord;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTree;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTreeParams;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.nodetable.NodeTableCache;
import com.hp.hpl.jena.tdb.nodetable.NodeTableInline;
import com.hp.hpl.jena.tdb.nodetable.NodeTableNative;
import com.hp.hpl.jena.tdb.setup.BlockMgrBuilder;
import com.hp.hpl.jena.tdb.setup.IndexBuilder;
import com.hp.hpl.jena.tdb.setup.NodeTableBuilder;
import com.hp.hpl.jena.tdb.setup.ObjectFileBuilder;
import com.hp.hpl.jena.tdb.setup.RangeIndexBuilder;
import com.hp.hpl.jena.tdb.setup.TupleIndexBuilder;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import org.openjena.atlas.lib.ColumnMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Builder {
    private static boolean VERBOSE = true;
    private static Logger log = LoggerFactory.getLogger(Builder.class);

    public static class BlockMgrBuilderStd
    implements BlockMgrBuilder {
        public BlockMgr buildBlockMgr(FileSet fileset, String ext, int blockSize) {
            int readCacheSize = SystemTDB.BlockReadCacheSize;
            int writeCacheSize = SystemTDB.BlockWriteCacheSize;
            BlockMgr mgr = BlockMgrFactory.create(fileset, ext, blockSize, readCacheSize, writeCacheSize);
            return mgr;
        }
    }

    public static class ObjectFileBuilderStd
    implements ObjectFileBuilder {
        public ObjectFile buildObjectFile(FileSet fileSet, String ext) {
            String filename = fileSet.filename(ext);
            if (fileSet.isMem()) {
                return FileFactory.createObjectFileMem(filename);
            }
            return FileFactory.createObjectFileDisk(filename);
        }
    }

    public static class RangeIndexBuilderStd
    implements RangeIndexBuilder {
        private BlockMgrBuilder bMgrNodes;
        private BlockMgrBuilder bMgrRecords;

        public RangeIndexBuilderStd(BlockMgrBuilder blockMgrBuilderNodes, BlockMgrBuilder blockMgrBuilderRecords) {
            this.bMgrNodes = blockMgrBuilderNodes;
            this.bMgrRecords = blockMgrBuilderRecords;
        }

        public RangeIndex buildRangeIndex(FileSet fileSet, RecordFactory recordFactory) {
            int blkSize = 8192;
            int order = BPlusTreeParams.calcOrder(blkSize, recordFactory.recordLength());
            int readCacheSize = SystemTDB.BlockReadCacheSize;
            int writeCacheSize = SystemTDB.BlockWriteCacheSize;
            RangeIndex rIndex = this.createBPTree(fileSet, order, blkSize, readCacheSize, writeCacheSize, this.bMgrNodes, this.bMgrRecords, recordFactory);
            return rIndex;
        }

        private RangeIndex createBPTree(FileSet fileset, int order, int blockSize, int readCacheSize, int writeCacheSize, BlockMgrBuilder blockMgrBuilderNodes, BlockMgrBuilder blockMgrBuilderRecords, RecordFactory factory) {
            int order2;
            if (blockSize < 0 && order < 0) {
                throw new IllegalArgumentException("Neither blocksize nor order specified");
            }
            if (blockSize >= 0 && order < 0) {
                order = BPlusTreeParams.calcOrder(blockSize, factory.recordLength());
            }
            if (blockSize >= 0 && order >= 0 && order != (order2 = BPlusTreeParams.calcOrder(blockSize, factory.recordLength()))) {
                throw new IllegalArgumentException("Wrong order (" + order + "), calculated = " + order2);
            }
            if (blockSize < 0 && order >= 0) {
                blockSize = BPlusTreeParams.calcBlockSize(order, factory);
            }
            BPlusTreeParams params = new BPlusTreeParams(order, factory);
            BlockMgr blkMgrNodes = blockMgrBuilderNodes.buildBlockMgr(fileset, "idn", blockSize);
            BlockMgr blkMgrRecords = blockMgrBuilderRecords.buildBlockMgr(fileset, "dat", blockSize);
            return BPlusTree.create(params, blkMgrNodes, blkMgrRecords);
        }
    }

    public static class IndexBuilderStd
    implements IndexBuilder {
        protected BlockMgrBuilder bMgrNodes;
        protected BlockMgrBuilder bMgrRecords;
        protected RangeIndexBuilderStd other;

        public IndexBuilderStd(BlockMgrBuilder bMgrNodes, BlockMgrBuilder bMgrRecords) {
            this.bMgrNodes = bMgrNodes;
            this.bMgrRecords = bMgrRecords;
            this.other = new RangeIndexBuilderStd(bMgrNodes, bMgrRecords);
        }

        public Index buildIndex(FileSet fileSet, RecordFactory recordFactory) {
            return this.other.buildRangeIndex(fileSet, recordFactory);
        }
    }

    public static class NodeTableBuilderStd
    implements NodeTableBuilder {
        private final IndexBuilder indexBuilder;
        private final ObjectFileBuilder objectFileBuilder;

        public NodeTableBuilderStd(IndexBuilder indexBuilder, ObjectFileBuilder objectFileBuilder) {
            this.indexBuilder = indexBuilder;
            this.objectFileBuilder = objectFileBuilder;
        }

        public NodeTable buildNodeTable(FileSet fsIndex, FileSet fsObjectFile, int sizeNode2NodeIdCache, int sizeNodeId2NodeCache, int sizeNodeMissCacheSize) {
            RecordFactory recordFactory = new RecordFactory(16, 8);
            Index idx = this.indexBuilder.buildIndex(fsIndex, recordFactory);
            ObjectFile objectFile = this.objectFileBuilder.buildObjectFile(fsObjectFile, "dat");
            NodeTable nodeTable = new NodeTableNative(idx, objectFile);
            nodeTable = NodeTableCache.create(nodeTable, sizeNode2NodeIdCache, sizeNodeId2NodeCache, sizeNodeMissCacheSize);
            nodeTable = NodeTableInline.create(nodeTable);
            return nodeTable;
        }
    }

    public static class TupleIndexBuilderStd
    implements TupleIndexBuilder {
        private final RangeIndexBuilder rangeIndexBuilder;

        public TupleIndexBuilderStd(RangeIndexBuilder rangeIndexBuilder) {
            this.rangeIndexBuilder = rangeIndexBuilder;
        }

        public TupleIndex buildTupleIndex(FileSet fileSet, ColumnMap colMap, String name) {
            RecordFactory recordFactory = new RecordFactory(8 * colMap.length(), 0);
            RangeIndex rIdx = this.rangeIndexBuilder.buildRangeIndex(fileSet, recordFactory);
            TupleIndexRecord tIdx = new TupleIndexRecord(colMap.length(), colMap, name, recordFactory, rIdx);
            return tIdx;
        }
    }
}

