/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.migrate;

import com.hp.hpl.jena.query.ReadWrite;
import com.hp.hpl.jena.shared.Lock;
import com.hp.hpl.jena.tdb.transaction.DatasetGraphTransaction;
import com.hp.hpl.jena.tdb.transaction.TDBTransactionException;

public class LockTx
implements Lock {
    private DatasetGraphTransaction dsg;
    private LockTxState state = LockTxState.TxNONE;

    public LockTx(DatasetGraphTransaction dsg) {
        this.dsg = dsg;
    }

    public void enterCriticalSection(boolean readLockRequested) {
        if (this.state != LockTxState.TxNONE) {
            throw new TDBTransactionException("Illegal state: " + (Object)((Object)this.state));
        }
        if (readLockRequested) {
            this.state = LockTxState.TxREAD;
            this.dsg.begin(ReadWrite.READ);
        } else {
            this.state = LockTxState.TxWRITE;
            this.dsg.begin(ReadWrite.WRITE);
        }
    }

    public void leaveCriticalSection() {
        switch (this.state) {
            case TxNONE: {
                throw new TDBTransactionException("Illegal state: " + (Object)((Object)this.state));
            }
            case TxREAD: {
                this.dsg.close();
                break;
            }
            case TxWRITE: {
                this.dsg.commit();
            }
        }
        this.state = LockTxState.TxNONE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum LockTxState {
        TxNONE,
        TxREAD,
        TxWRITE;

    }
}

