/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.file;

import com.hp.hpl.jena.tdb.base.StorageException;
import com.hp.hpl.jena.tdb.base.file.BufferChannel;
import java.nio.ByteBuffer;

public class BufferChannelMem
implements BufferChannel {
    private ByteBuffer bytes;
    private String name;
    private static int INIT_SIZE = 1024;
    private static int INC_SIZE = 1024;

    public static BufferChannel create() {
        return new BufferChannelMem("unnamed");
    }

    public static BufferChannel create(String name) {
        return new BufferChannelMem(name);
    }

    private BufferChannelMem() {
    }

    private BufferChannelMem(String name) {
        this.bytes = ByteBuffer.allocate(1024);
        this.bytes.limit(0);
        this.name = name;
    }

    public synchronized BufferChannel duplicate() {
        BufferChannelMem chan = new BufferChannelMem();
        int x = this.bytes.position();
        this.bytes.rewind();
        chan.bytes = this.bytes.slice();
        chan.bytes.position(0);
        this.bytes.position(x);
        return chan;
    }

    public synchronized long position() {
        this.checkIfClosed();
        return this.bytes.position();
    }

    public synchronized void position(long pos) {
        this.checkIfClosed();
        if (pos < 0L || pos > (long)this.bytes.capacity()) {
            throw new StorageException("Out of range: " + pos);
        }
        this.bytes.position((int)pos);
    }

    public synchronized int read(ByteBuffer buffer) {
        this.checkIfClosed();
        int x = this.bytes.position();
        int len = buffer.limit() - buffer.position();
        if (len > this.bytes.remaining()) {
            len = this.bytes.remaining();
        }
        for (int i = 0; i < len; ++i) {
            byte b = this.bytes.get();
            buffer.put(b);
        }
        return len;
    }

    public synchronized int read(ByteBuffer buffer, long loc) {
        this.checkIfClosed();
        if (loc < 0L || loc >= (long)this.bytes.limit()) {
            throw new StorageException("Out of range: " + loc + " [0," + buffer.limit() + ")");
        }
        int x = buffer.position();
        this.bytes.position((int)loc);
        int len = this.read(buffer);
        this.bytes.position(x);
        return len;
    }

    public synchronized int write(ByteBuffer buffer) {
        this.checkIfClosed();
        int len = buffer.limit() - buffer.position();
        int posn = this.bytes.position();
        int freespace = this.bytes.capacity() - this.bytes.position();
        if (len > freespace) {
            int inc = len - freespace;
            ByteBuffer bb2 = ByteBuffer.allocate(this.bytes.capacity() + (inc += INC_SIZE));
            this.bytes.position(0);
            bb2.put(this.bytes);
            bb2.limit(this.bytes.limit());
            bb2.position(posn);
            this.bytes = bb2;
        }
        if (this.bytes.limit() < posn + len) {
            this.bytes.limit(posn + len);
        }
        this.bytes.put(buffer);
        return len;
    }

    public synchronized int write(ByteBuffer buffer, long loc) {
        this.checkIfClosed();
        if (loc < 0L || loc > (long)this.bytes.limit()) {
            throw new StorageException("Out of range: " + loc);
        }
        int x = this.bytes.position();
        this.bytes.position((int)loc);
        int len = this.write(buffer);
        this.bytes.position(x);
        return len;
    }

    public synchronized void truncate(long size) {
        this.checkIfClosed();
        int x = (int)size;
        if (x < 0) {
            throw new StorageException("Out of range: " + size);
        }
        if (x > this.bytes.limit()) {
            return;
        }
        if (this.bytes.position() > x) {
            this.bytes.position(x);
        }
        this.bytes.limit(x);
    }

    public synchronized long size() {
        this.checkIfClosed();
        return this.bytes.limit();
    }

    public synchronized boolean isEmpty() {
        this.checkIfClosed();
        return this.size() == 0L;
    }

    public synchronized void sync() {
        this.checkIfClosed();
    }

    public synchronized void close() {
        this.checkIfClosed();
        this.bytes = null;
    }

    private void checkIfClosed() {
        if (this.bytes == null) {
            throw new StorageException("Closed: " + this.name);
        }
    }

    public synchronized String getLabel() {
        return this.name;
    }

    public synchronized String toString() {
        return this.name;
    }

    public String getFilename() {
        return null;
    }
}

