/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.file;

import com.hp.hpl.jena.tdb.base.file.BufferChannel;
import com.hp.hpl.jena.tdb.base.file.FileBase;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.openjena.atlas.io.IO;
import org.openjena.atlas.lib.FileOps;

public class BufferChannelFile
implements BufferChannel {
    private FileBase file;

    public BufferChannelFile(String filename) {
        this.file = FileBase.create(filename);
    }

    public BufferChannel duplicate() {
        return new BufferChannelFile(this.file.filename);
    }

    public long position() {
        try {
            return this.file.channel().position();
        }
        catch (IOException e) {
            IO.exception((IOException)e);
            return -1L;
        }
    }

    public void position(long pos) {
        try {
            this.file.channel().position(pos);
        }
        catch (IOException e) {
            IO.exception((IOException)e);
        }
    }

    public void truncate(long length) {
        try {
            if (length < this.file.channel().position()) {
                this.file.channel().position(length);
            }
            this.file.channel().truncate(length);
        }
        catch (IOException e) {
            IO.exception((IOException)e);
        }
    }

    public int read(ByteBuffer buffer) {
        try {
            return this.file.channel().read(buffer);
        }
        catch (IOException e) {
            IO.exception((IOException)e);
            return -1;
        }
    }

    public int read(ByteBuffer buffer, long loc) {
        try {
            return this.file.channel().read(buffer, loc);
        }
        catch (IOException e) {
            IO.exception((IOException)e);
            return -1;
        }
    }

    public int write(ByteBuffer buffer) {
        try {
            return this.file.channel().write(buffer);
        }
        catch (IOException e) {
            IO.exception((IOException)e);
            return -1;
        }
    }

    public int write(ByteBuffer buffer, long loc) {
        try {
            return this.file.channel().write(buffer, loc);
        }
        catch (IOException e) {
            IO.exception((IOException)e);
            return -1;
        }
    }

    public long size() {
        try {
            return this.file.channel().size();
        }
        catch (IOException e) {
            IO.exception((IOException)e);
            return -1L;
        }
    }

    public boolean isEmpty() {
        try {
            return this.file.channel().size() == 0L;
        }
        catch (IOException e) {
            IO.exception((IOException)e);
            return false;
        }
    }

    public void sync() {
        this.file.sync();
    }

    public void close() {
        this.file.close();
    }

    public String getLabel() {
        return FileOps.basename((String)this.file.getFilename());
    }

    public String toString() {
        return this.file.getFilename();
    }

    public String getFilename() {
        return this.file.getFilename();
    }
}

