/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.block;

import com.hp.hpl.jena.sparql.util.Named;
import com.hp.hpl.jena.tdb.TDBException;
import org.openjena.atlas.io.IndentedWriter;
import org.openjena.atlas.io.Printable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BlockType implements Printable,
Named
{
    FREE(-1, "Free"),
    BTREE_NODE(5, "BTreeNode"),
    BPTREE_BRANCH(6, "BPlusTreeBranch"),
    BPTREE_LEAF(7, "BPlusTreeLeaf"),
    DICTIONARY(10, "Dictionary"),
    RECORD_BLOCK(99, "RecordBlock"),
    UNDEF(-2, "UndefinedBlockType");

    private final int id;
    private final String name;

    private BlockType(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public void output(IndentedWriter out) {
        out.print((Object)this.getName());
    }

    public final int id() {
        return this.id;
    }

    public final String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public static BlockType extract(int x) {
        if (x == BTREE_NODE.id()) {
            return BTREE_NODE;
        }
        if (x == BPTREE_BRANCH.id()) {
            return BPTREE_BRANCH;
        }
        if (x == BPTREE_LEAF.id()) {
            return BPTREE_LEAF;
        }
        if (x == RECORD_BLOCK.id()) {
            return RECORD_BLOCK;
        }
        if (x == DICTIONARY.id()) {
            return DICTIONARY;
        }
        throw new TDBException("No known block type for " + x);
    }
}

