/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.out;

import com.hp.hpl.jena.graph.Node;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import org.openjena.atlas.io.IndentedWriter;
import org.openjena.atlas.json.io.JSWriter;
import org.openjena.atlas.lib.Pair;
import org.openjena.atlas.lib.Sink;
import org.openjena.riot.RiotException;
import org.openjena.riot.out.NodeToLabel;
import org.openjena.riot.system.Prologue;
import org.openjena.riot.system.SyntaxLabels;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SinkEntityOutput
implements Sink<Pair<Node, Map<Node, Set<Node>>>> {
    private Prologue prologue = null;
    private NodeToLabel labelPolicy = null;
    private JSWriter out;

    public SinkEntityOutput(OutputStream outs) {
        this(outs, null, SyntaxLabels.createNodeToLabel());
    }

    public SinkEntityOutput(OutputStream outs, Prologue prologue, NodeToLabel labels) {
        this.init(new JSWriter(outs), prologue, labels);
    }

    public SinkEntityOutput(Writer outs) {
        this(outs, null, SyntaxLabels.createNodeToLabel());
    }

    public SinkEntityOutput(Writer outs, Prologue prologue, NodeToLabel labels) {
        this.init(new JSWriter(new IndentedWriterEx(outs)), prologue, labels);
    }

    private void init(JSWriter out, Prologue prologue, NodeToLabel labels) {
        this.out = out;
        this.setPrologue(prologue);
        this.setLabelPolicy(labels);
        out.startOutput();
        out.startObject();
    }

    public void setPrologue(Prologue prologue) {
        this.prologue = prologue;
    }

    public void setLabelPolicy(NodeToLabel labels) {
        this.labelPolicy = labels;
    }

    @Override
    public void send(Pair<Node, Map<Node, Set<Node>>> item) {
        Node s = item.getLeft();
        if (s.isBlank()) {
            this.out.key("_:" + s.getBlankNodeLabel());
        } else if (s.isURI()) {
            this.out.key(s.getURI());
        } else {
            throw new RiotException("Only URIs or blank nodes are legal subjects.");
        }
        this.out.startObject();
        Map<Node, Set<Node>> predicates = item.getRight();
        for (Node p : predicates.keySet()) {
            this.out.key(p.getURI());
            this.out.startArray();
            Set<Node> objects = predicates.get(p);
            int i = 0;
            for (Node o : objects) {
                this.out.startObject();
                if (o.isBlank()) {
                    this.out.pair("type", "bnode");
                    this.out.pair("value", "_:" + o.getBlankNodeLabel());
                } else if (o.isURI()) {
                    this.out.pair("type", "uri");
                    this.out.pair("value", o.getURI());
                } else if (o.isLiteral()) {
                    String dt = o.getLiteralDatatypeURI();
                    String lang = o.getLiteralLanguage();
                    String lex = o.getLiteralLexicalForm();
                    this.out.pair("type", "literal");
                    this.out.pair("value", lex);
                    if (dt != null) {
                        this.out.pair("datatype", dt);
                    }
                    if (lang != null && lang != "") {
                        this.out.pair("lang", lang);
                    }
                }
                this.out.finishObject();
                if (i < objects.size() - 1) {
                    this.out.arraySep();
                }
                ++i;
            }
            this.out.finishArray();
        }
        this.out.finishObject();
    }

    @Override
    public void flush() {
        this.out.finishObject();
        this.out.finishOutput();
    }

    @Override
    public void close() {
        this.flush();
    }

    private class IndentedWriterEx
    extends IndentedWriter {
        public IndentedWriterEx(Writer writer) {
            super(writer);
        }
    }
}

