/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingInputStream;
import com.hp.hpl.jena.sparql.engine.binding.BindingOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.openjena.atlas.data.SerializationFactory;
import org.openjena.atlas.lib.Sink;
import org.openjena.riot.lang.LabelToNode;
import org.openjena.riot.lang.LangNQuads;
import org.openjena.riot.lang.LangNTriples;
import org.openjena.riot.out.NodeToLabel;
import org.openjena.riot.out.SinkQuadOutput;
import org.openjena.riot.out.SinkTripleOutput;
import org.openjena.riot.system.IRIResolver;
import org.openjena.riot.system.ParserProfile;
import org.openjena.riot.system.ParserProfileBase;
import org.openjena.riot.system.Prologue;
import org.openjena.riot.tokens.Tokenizer;
import org.openjena.riot.tokens.TokenizerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializationFactoryFinder {
    public static SerializationFactory<Binding> bindingSerializationFactory() {
        return new SerializationFactory<Binding>(){

            @Override
            public Sink<Binding> createSerializer(OutputStream out) {
                return new BindingOutputStream(out);
            }

            @Override
            public Iterator<Binding> createDeserializer(InputStream in) {
                return new BindingInputStream(in);
            }

            @Override
            public long getEstimatedMemorySize(Binding item) {
                return 0L;
            }
        };
    }

    public static SerializationFactory<Triple> tripleSerializationFactory() {
        return new SerializationFactory<Triple>(){

            @Override
            public Sink<Triple> createSerializer(OutputStream out) {
                return new SinkTripleOutput(out, null, NodeToLabel.createBNodeByLabelEncoded());
            }

            @Override
            public Iterator<Triple> createDeserializer(InputStream in) {
                Tokenizer tokenizer = TokenizerFactory.makeTokenizerASCII(in);
                ParserProfileBase profile = new ParserProfileBase(new Prologue(null, IRIResolver.createNoResolve()), null, LabelToNode.createUseLabelEncoded());
                LangNTriples parser = new LangNTriples(tokenizer, (ParserProfile)profile, null);
                return parser;
            }

            @Override
            public long getEstimatedMemorySize(Triple item) {
                return 0L;
            }
        };
    }

    public static SerializationFactory<Quad> quadSerializationFactory() {
        return new SerializationFactory<Quad>(){

            @Override
            public Sink<Quad> createSerializer(OutputStream out) {
                return new SinkQuadOutput(out, null, NodeToLabel.createBNodeByLabelEncoded());
            }

            @Override
            public Iterator<Quad> createDeserializer(InputStream in) {
                Tokenizer tokenizer = TokenizerFactory.makeTokenizerASCII(in);
                ParserProfileBase profile = new ParserProfileBase(new Prologue(null, IRIResolver.createNoResolve()), null, LabelToNode.createUseLabelEncoded());
                LangNQuads parser = new LangNQuads(tokenizer, (ParserProfile)profile, null);
                return parser;
            }

            @Override
            public long getEstimatedMemorySize(Quad item) {
                return 0L;
            }
        };
    }
}

