/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.lib;

import org.openjena.atlas.lib.Lib;
import org.openjena.atlas.lib.StrUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pair<A, B> {
    final A a;
    final B b;

    public static <L, R> Pair<L, R> create(L x, R y) {
        return new Pair<L, R>(x, y);
    }

    public Pair(A a, B b) {
        this.a = a;
        this.b = b;
    }

    public A getLeft() {
        return this.a;
    }

    public B getRight() {
        return this.b;
    }

    public A car() {
        return this.a;
    }

    public B cdr() {
        return this.b;
    }

    public int hashCode() {
        return Lib.hashCodeObject(this.car()) ^ Lib.hashCodeObject(this.cdr()) << 1;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Pair)) {
            return false;
        }
        Pair p2 = (Pair)other;
        return Lib.equal(this.car(), p2.car()) && Lib.equal(this.cdr(), p2.cdr());
    }

    public String toString() {
        return "(" + StrUtils.str(this.a) + ", " + StrUtils.str(this.b) + ")";
    }
}

